/*
 * Decompiled with CFR 0.152.
 */
package web.Regional_Api.controller;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import web.Regional_Api.dto.AccesoConModuloDTO;
import web.Regional_Api.entity.Acceso;
import web.Regional_Api.service.jpa.AccesoService;

@RestController
@RequestMapping(value={"/accesos"})
public class AccesoController {
    @Autowired
    private AccesoService accesoService;

    @GetMapping
    public ResponseEntity<List<Acceso>> getAllAccesos() {
        return ResponseEntity.ok((Object)this.accesoService.getAllAccesos());
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<Acceso> getAccesoById(@PathVariable Integer id) {
        return this.accesoService.getAccesoById(id).map(ResponseEntity::ok).orElseGet(() -> ResponseEntity.notFound().build());
    }

    @PostMapping
    public ResponseEntity<?> createAcceso(@RequestBody Acceso acceso) {
        if (this.accesoService.existeAcceso(acceso.getIdModulo(), acceso.getIdPerfil())) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CONFLICT).body((Object)"Ya existe un acceso para este m\u00f3dulo y perfil");
        }
        Acceso saved = this.accesoService.saveAcceso(acceso);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)saved);
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<Acceso> updateAcceso(@PathVariable Integer id, @RequestBody Acceso acceso) {
        return this.accesoService.getAccesoById(id).map(existing -> {
            acceso.setIdAcceso(id);
            Acceso updated = this.accesoService.saveAcceso(acceso);
            return ResponseEntity.ok((Object)updated);
        }).orElseGet(() -> ResponseEntity.notFound().build());
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Void> deleteAcceso(@PathVariable Integer id) {
        if (this.accesoService.getAccesoById(id).isEmpty()) {
            return ResponseEntity.notFound().build();
        }
        this.accesoService.deleteAcceso(id);
        return ResponseEntity.noContent().build();
    }

    @DeleteMapping(value={"/perfil/{idPerfil}"})
    public ResponseEntity<Void> deleteAccesosByPerfil(@PathVariable Integer idPerfil) {
        this.accesoService.deleteAccesosByPerfil(idPerfil);
        return ResponseEntity.noContent().build();
    }

    @GetMapping(value={"/perfil/{idPerfil}"})
    public ResponseEntity<List<Acceso>> getAccesosByPerfil(@PathVariable Integer idPerfil) {
        List accesos = this.accesoService.getAccesosByPerfil(idPerfil);
        return ResponseEntity.ok((Object)accesos);
    }

    @GetMapping(value={"/verificar/{idPerfil}/{idModulo}"})
    public ResponseEntity<Boolean> verificarAcceso(@PathVariable Integer idPerfil, @PathVariable Integer idModulo) {
        boolean tieneAcceso = this.accesoService.tieneAcceso(idPerfil, idModulo);
        return ResponseEntity.ok((Object)tieneAcceso);
    }

    @GetMapping(value={"/perfil/{idPerfil}/completo"})
    public ResponseEntity<List<AccesoConModuloDTO>> getAccesosConModuloByPerfil(@PathVariable Integer idPerfil) {
        List accesos = this.accesoService.getAccesosConModuloByPerfil(idPerfil);
        return ResponseEntity.ok((Object)accesos);
    }
}

