/*
 * Decompiled with CFR 0.152.
 */
package web.Regional_Api.controller;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import web.Regional_Api.entity.Categoria;
import web.Regional_Api.entity.CategoriaDTO;
import web.Regional_Api.entity.Sucursales;
import web.Regional_Api.repository.CategoriaRepository;
import web.Regional_Api.repository.RestauranteRepository;
import web.Regional_Api.repository.SucursalesRepository;
import web.Regional_Api.service.ICategoriaService;

@RestController
@RequestMapping(value={"/api/categorias"})
public class CategoriaController {
    @Autowired
    private ICategoriaService categoriaService;
    @Autowired
    private CategoriaRepository categoriaRepository;
    @Autowired
    private RestauranteRepository restauranteRepository;
    @Autowired
    private SucursalesRepository sucursalesRepository;

    @GetMapping
    public ResponseEntity<List<CategoriaDTO>> obtenerTodas() {
        List categorias = this.categoriaService.buscarTodos().stream().map(arg_0 -> this.convertirADTO(arg_0)).collect(Collectors.toList());
        return ResponseEntity.ok(categorias);
    }

    @GetMapping(value={"/activas"})
    public ResponseEntity<List<CategoriaDTO>> obtenerActivas() {
        List categorias = this.categoriaService.buscarActivas().stream().map(arg_0 -> this.convertirADTO(arg_0)).collect(Collectors.toList());
        return ResponseEntity.ok(categorias);
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<CategoriaDTO> obtenerPorId(@PathVariable Integer id) {
        return this.categoriaService.buscarId(id).map(arg_0 -> this.convertirADTO(arg_0)).map(ResponseEntity::ok).orElse(ResponseEntity.notFound().build());
    }

    @PostMapping
    public ResponseEntity<?> crear(@RequestBody CategoriaDTO categoriaDTO) {
        Optional optSucursal = this.sucursalesRepository.findById((Object)categoriaDTO.getId_sucursal());
        if (optSucursal.isEmpty()) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)("Error: La sucursal con ID " + String.valueOf(categoriaDTO.getId_sucursal()) + " no existe."));
        }
        Categoria categoria = new Categoria();
        categoria.setSucursales((Sucursales)optSucursal.get());
        categoria.setNombre(categoriaDTO.getNombre());
        categoria.setDescripcion(categoriaDTO.getDescripcion());
        categoria.setEstado(Integer.valueOf(categoriaDTO.getEstado() != null ? categoriaDTO.getEstado() : 1));
        try {
            Categoria guardada = (Categoria)this.categoriaRepository.save((Object)categoria);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)this.convertirADTO(guardada));
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("Error al guardar: " + e.getMessage()));
        }
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<CategoriaDTO> actualizar(@PathVariable Integer id, @RequestBody CategoriaDTO categoriaDTO) {
        Optional optional = this.categoriaService.buscarId(id);
        if (optional.isEmpty()) {
            return ResponseEntity.notFound().build();
        }
        Categoria categoria = (Categoria)optional.get();
        if (categoriaDTO.getNombre() != null) {
            categoria.setNombre(categoriaDTO.getNombre());
        }
        if (categoriaDTO.getDescripcion() != null) {
            categoria.setDescripcion(categoriaDTO.getDescripcion());
        }
        Categoria actualizada = this.categoriaService.modificar(categoria);
        return ResponseEntity.ok((Object)this.convertirADTO(actualizada));
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Void> eliminar(@PathVariable Integer id) {
        Optional optional = this.categoriaService.buscarId(id);
        if (optional.isEmpty()) {
            return ResponseEntity.notFound().build();
        }
        this.categoriaService.eliminar(id);
        return ResponseEntity.noContent().build();
    }

    private CategoriaDTO convertirADTO(Categoria entidad) {
        CategoriaDTO dto = new CategoriaDTO();
        dto.setId_categoria(entidad.getId_categoria());
        if (entidad.getSucursales() != null) {
            dto.setId_sucursal(entidad.getSucursales().getIdSucursal());
        }
        dto.setNombre(entidad.getNombre());
        dto.setDescripcion(entidad.getDescripcion());
        dto.setEstado(entidad.getEstado());
        return dto;
    }
}

