/*
 * Decompiled with CFR 0.152.
 */
package web.Regional_Api.controller;

import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import web.Regional_Api.entity.DetallePedido;
import web.Regional_Api.service.IDetallePedidoService;

@RestController
@RequestMapping(value={"/api/detalles-pedido"})
public class DetallePedidoController {
    @Autowired
    private IDetallePedidoService detallePedidoService;

    @GetMapping
    public ResponseEntity<List<DetallePedido>> buscarTodos() {
        try {
            List detalles = this.detallePedidoService.buscarTodos();
            return new ResponseEntity((Object)detalles, (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<DetallePedido> buscarPorId(@PathVariable Integer id) {
        try {
            Optional detalle = this.detallePedidoService.buscarId(id);
            if (detalle.isPresent()) {
                return new ResponseEntity((Object)((DetallePedido)detalle.get()), (HttpStatusCode)HttpStatus.OK);
            }
            return ResponseEntity.notFound().build();
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
    }

    @PostMapping
    public ResponseEntity<DetallePedido> guardar(@RequestBody DetallePedido detallePedido) {
        try {
            DetallePedido detalleGuardado = this.detallePedidoService.guardar(detallePedido);
            return new ResponseEntity((Object)detalleGuardado, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (Exception e) {
            return ResponseEntity.badRequest().build();
        }
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<DetallePedido> modificar(@PathVariable Integer id, @RequestBody DetallePedido detallePedido) {
        try {
            detallePedido.setIdDetalle(id);
            DetallePedido detalleModificado = this.detallePedidoService.modificar(detallePedido);
            return new ResponseEntity((Object)detalleModificado, (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            return ResponseEntity.badRequest().build();
        }
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<String> eliminar(@PathVariable Integer id) {
        try {
            this.detallePedidoService.eliminar(id);
            return new ResponseEntity((Object)"Detalle eliminado correctamente", (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            return new ResponseEntity((Object)"Error al eliminar detalle", (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @GetMapping(value={"/pedido/{idPedido}"})
    public ResponseEntity<List<DetallePedido>> buscarPorPedido(@PathVariable Integer idPedido) {
        try {
            List detalles = this.detallePedidoService.buscarPorPedido(idPedido);
            return new ResponseEntity((Object)detalles, (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GetMapping(value={"/plato/{idPlato}"})
    public ResponseEntity<List<DetallePedido>> buscarPorPlato(@PathVariable Integer idPlato) {
        try {
            List detalles = this.detallePedidoService.buscarPorPlato(idPlato);
            return new ResponseEntity((Object)detalles, (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
    }
}

