/*
 * Decompiled with CFR 0.152.
 */
package web.Regional_Api.controller;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import web.Regional_Api.entity.Mesas;
import web.Regional_Api.entity.MesasDTO;
import web.Regional_Api.entity.Sucursales;
import web.Regional_Api.repository.SucursalesRepository;
import web.Regional_Api.service.IMesasService;

@RestController
@RequestMapping(value={"/restful/mesas"})
public class MesasController {
    @Autowired
    private IMesasService mesasService;
    @Autowired
    private SucursalesRepository sucursalesRepository;

    @GetMapping
    public ResponseEntity<List<MesasDTO>> listarMesas() {
        List mesas = this.mesasService.buscarTodos().stream().map(arg_0 -> this.convertToDto(arg_0)).collect(Collectors.toList());
        return new ResponseEntity(mesas, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<MesasDTO> obtenerMesaPorId(@PathVariable Integer id) {
        Optional mesa = this.mesasService.buscarId(id);
        if (mesa.isPresent()) {
            return new ResponseEntity((Object)this.convertToDto((Mesas)mesa.get()), (HttpStatusCode)HttpStatus.OK);
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    @PostMapping
    public ResponseEntity<?> crearMesa(@RequestBody MesasDTO mesaDTO) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        if (mesaDTO == null || mesaDTO.getId_sucursal() == null || mesaDTO.getNumero_mesa() == null || mesaDTO.getCapacidad() == null || mesaDTO.getEstado_mesa() == null) {
            response.put("message", "id_sucursal, numero_mesa, capacidad y estado_mesa son obligatorios");
            return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body(response);
        }
        Optional sucursalOpt = this.sucursalesRepository.findById((Object)mesaDTO.getId_sucursal());
        if (sucursalOpt.isEmpty()) {
            response.put("message", "La sucursal indicada no existe");
            return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body(response);
        }
        Optional estadoOpt = this.parseEstadoMesa(mesaDTO.getEstado_mesa());
        if (estadoOpt.isEmpty()) {
            response.put("message", "Estado de mesa inv\u00e1lido. Valores permitidos: " + Arrays.toString(Mesas.EstadoMesa.values()));
            return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body(response);
        }
        Mesas mesa = new Mesas();
        mesa.setId_sucursal((Sucursales)sucursalOpt.get());
        mesa.setNumero_mesa(mesaDTO.getNumero_mesa());
        mesa.setCapacidad(mesaDTO.getCapacidad());
        mesa.setEstado_mesa((Mesas.EstadoMesa)estadoOpt.get());
        mesa.setEstado(Integer.valueOf(1));
        Mesas nuevaMesa = this.mesasService.guardar(mesa);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)this.convertToDto(nuevaMesa));
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<?> actualizarMesa(@PathVariable Integer id, @RequestBody MesasDTO mesaDTO) {
        Optional mesaExistente = this.mesasService.buscarId(id);
        if (mesaExistente.isEmpty()) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).build();
        }
        Mesas mesa = (Mesas)mesaExistente.get();
        HashMap<String, Object> response = new HashMap<String, Object>();
        if (mesaDTO.getId_sucursal() != null) {
            Optional sucursalOpt = this.sucursalesRepository.findById((Object)mesaDTO.getId_sucursal());
            if (sucursalOpt.isEmpty()) {
                response.put("message", "La sucursal indicada no existe");
                return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body(response);
            }
            mesa.setId_sucursal((Sucursales)sucursalOpt.get());
        }
        if (mesaDTO.getNumero_mesa() != null) {
            mesa.setNumero_mesa(mesaDTO.getNumero_mesa());
        }
        if (mesaDTO.getCapacidad() != null) {
            mesa.setCapacidad(mesaDTO.getCapacidad());
        }
        if (mesaDTO.getEstado_mesa() != null) {
            Optional estadoOpt = this.parseEstadoMesa(mesaDTO.getEstado_mesa());
            if (estadoOpt.isEmpty()) {
                response.put("message", "Estado de mesa inv\u00e1lido. Valores permitidos: " + Arrays.toString(Mesas.EstadoMesa.values()));
                return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body(response);
            }
            mesa.setEstado_mesa((Mesas.EstadoMesa)estadoOpt.get());
        }
        Mesas mesaActualizada = this.mesasService.modificar(mesa);
        return ResponseEntity.ok((Object)this.convertToDto(mesaActualizada));
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Void> eliminarMesa(@PathVariable Integer id) {
        Optional mesa = this.mesasService.buscarId(id);
        if (mesa.isPresent()) {
            this.mesasService.eliminar(id);
            return new ResponseEntity((HttpStatusCode)HttpStatus.NO_CONTENT);
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    @GetMapping(value={"/sucursal/{idSucursal}"})
    public ResponseEntity<List<MesasDTO>> listarMesasPorSucursal(@PathVariable Integer idSucursal) {
        List mesas = this.mesasService.buscarTodos().stream().map(arg_0 -> this.convertToDto(arg_0)).collect(Collectors.toList());
        return new ResponseEntity(mesas, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/estado/{estado}"})
    public ResponseEntity<List<MesasDTO>> listarMesasPorEstado(@PathVariable String estado) {
        List mesas = this.mesasService.buscarTodos().stream().map(arg_0 -> this.convertToDto(arg_0)).collect(Collectors.toList());
        return new ResponseEntity(mesas, (HttpStatusCode)HttpStatus.OK);
    }

    private Optional<Mesas.EstadoMesa> parseEstadoMesa(String estado) {
        if (estado == null) {
            return Optional.empty();
        }
        return Arrays.stream(Mesas.EstadoMesa.values()).filter(e -> e.name().equalsIgnoreCase(estado)).findFirst();
    }

    private MesasDTO convertToDto(Mesas mesa) {
        MesasDTO dto = new MesasDTO();
        dto.setId_mesa(mesa.getId_mesa());
        Sucursales sucursal = mesa.getId_sucursal();
        if (sucursal != null) {
            dto.setId_sucursal(sucursal.getIdSucursal());
        }
        dto.setNumero_mesa(mesa.getNumero_mesa());
        dto.setCapacidad(mesa.getCapacidad());
        dto.setEstado_mesa(mesa.getEstado_mesa() != null ? mesa.getEstado_mesa().name() : null);
        return dto;
    }
}

