/*
 * Decompiled with CFR 0.152.
 */
package web.Regional_Api.controller;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import web.Regional_Api.entity.Modulo;
import web.Regional_Api.service.jpa.ModuloService;

@RestController
@RequestMapping(value={"/modulos"})
public class ModuloController {
    @Autowired
    private ModuloService moduloService;

    @GetMapping
    public ResponseEntity<List<Modulo>> getAllModulos() {
        return ResponseEntity.ok((Object)this.moduloService.getAllModulos());
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<Modulo> getModuloById(@PathVariable Integer id) {
        return this.moduloService.getModuloById(id).map(ResponseEntity::ok).orElseGet(() -> ResponseEntity.notFound().build());
    }

    @PostMapping
    public ResponseEntity<Modulo> createModulo(@RequestBody Modulo modulo) {
        Modulo saved = this.moduloService.saveModulo(modulo);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)saved);
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<Modulo> updateModulo(@PathVariable Integer id, @RequestBody Modulo modulo) {
        return this.moduloService.getModuloById(id).map(existing -> {
            modulo.setIdModulo(id);
            Modulo updated = this.moduloService.saveModulo(modulo);
            return ResponseEntity.ok((Object)updated);
        }).orElseGet(() -> ResponseEntity.notFound().build());
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Void> deleteModulo(@PathVariable Integer id) {
        if (this.moduloService.getModuloById(id).isEmpty()) {
            return ResponseEntity.notFound().build();
        }
        this.moduloService.deleteModulo(id);
        return ResponseEntity.noContent().build();
    }
}

