/*
 * Decompiled with CFR 0.152.
 */
package web.Regional_Api.controller;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import web.Regional_Api.entity.MovimientosCaja;
import web.Regional_Api.service.IMovimientosCajaService;
import web.Regional_Api.service.ISesionesCajaService;

@RestController
@RequestMapping(value={"/restful"})
public class MovimientosCajaController {
    @Autowired
    private IMovimientosCajaService serviceMovimientos;
    @Autowired
    private ISesionesCajaService serviceSesiones;

    @GetMapping(value={"/caja/movimientos/{idSesion}"})
    public List<MovimientosCaja> buscarPorSesion(@PathVariable(value="idSesion") Integer idSesion) {
        return this.serviceMovimientos.buscarPorSesion(idSesion);
    }

    @GetMapping(value={"/caja/movimientos/todos"})
    public List<MovimientosCaja> buscarTodos() {
        return this.serviceMovimientos.buscarTodos();
    }

    @PostMapping(value={"/caja/movimientos"})
    public MovimientosCaja registrarMovimiento(@RequestBody MovimientosCaja movimiento) {
        this.serviceMovimientos.registrarMovimiento(movimiento);
        return movimiento;
    }

    @PutMapping(value={"/caja/movimientos"})
    public MovimientosCaja modificarMovimiento(@RequestBody MovimientosCaja movimientoActualizado) {
        this.serviceMovimientos.modificarMovimiento(movimientoActualizado);
        return movimientoActualizado;
    }

    @DeleteMapping(value={"/caja/movimientos/{id}"})
    public String eliminarMovimiento(@PathVariable(value="id") Integer idMovimiento) {
        this.serviceMovimientos.eliminarMovimiento(idMovimiento);
        return "Movimiento eliminado exitosamente";
    }
}

