/*
 * Decompiled with CFR 0.152.
 */
package web.Regional_Api.controller;

import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import web.Regional_Api.entity.Insumos;
import web.Regional_Api.entity.MovimientosInventario;
import web.Regional_Api.entity.MovimientosInventarioDTO;
import web.Regional_Api.entity.Proveedores;
import web.Regional_Api.entity.Usuarios;
import web.Regional_Api.repository.InsumosRepository;
import web.Regional_Api.repository.ProveedoresRepository;
import web.Regional_Api.repository.UsuarioRepository;
import web.Regional_Api.service.IMovimientosInventarioService;

@RestController
@RequestMapping(value={"/regional/movimientos-inventario"})
public class MovimientosInventarioController {
    @Autowired
    private IMovimientosInventarioService serviceMovimientos;
    @Autowired
    private InsumosRepository repoInsumos;
    @Autowired
    private UsuarioRepository repoUsuario;
    @Autowired
    private ProveedoresRepository repoProveedores;

    @GetMapping
    public List<MovimientosInventarioDTO> buscarTodos() {
        return this.serviceMovimientos.buscarTodos().stream().map(arg_0 -> this.convertirADTO(arg_0)).collect(Collectors.toList());
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<MovimientosInventarioDTO> buscarPorId(@PathVariable Integer id) {
        return this.serviceMovimientos.buscarId(id).map(arg_0 -> this.convertirADTO(arg_0)).map(ResponseEntity::ok).orElse(ResponseEntity.notFound().build());
    }

    @PostMapping
    public ResponseEntity<MovimientosInventarioDTO> guardar(@RequestBody MovimientosInventarioDTO dto) {
        try {
            MovimientosInventario entidad = this.convertirAEntidad(dto);
            MovimientosInventario entidadGuardada = this.serviceMovimientos.guardar(entidad);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)this.convertirADTO(entidadGuardada));
        }
        catch (RuntimeException e) {
            return ResponseEntity.badRequest().body(null);
        }
    }

    private MovimientosInventarioDTO convertirADTO(MovimientosInventario entidad) {
        MovimientosInventarioDTO dto = new MovimientosInventarioDTO();
        dto.setId_movimiento(entidad.getId_movimiento());
        dto.setCantidad(entidad.getCantidad());
        dto.setMotivo(entidad.getMotivo());
        dto.setTipo_movimiento(entidad.getTipo_movimiento().name());
        dto.setFecha_movimiento(entidad.getFecha_movimiento());
        dto.setIdInsumo(entidad.getInsumo().getId_insumo());
        dto.setIdUsuario(entidad.getUsuario().getIdUsuario());
        if (entidad.getProveedor() != null) {
            dto.setIdProveedor(entidad.getProveedor().getId_proveedor());
        }
        return dto;
    }

    private MovimientosInventario convertirAEntidad(MovimientosInventarioDTO dto) {
        MovimientosInventario entidad = new MovimientosInventario();
        entidad.setCantidad(dto.getCantidad());
        entidad.setMotivo(dto.getMotivo());
        entidad.setTipo_movimiento(MovimientosInventario.TipoMovimiento.valueOf((String)dto.getTipo_movimiento()));
        Insumos insumo = (Insumos)this.repoInsumos.findById((Object)dto.getIdInsumo()).orElseThrow(() -> new RuntimeException("Insumo no encontrado"));
        entidad.setInsumo(insumo);
        Usuarios usuario = (Usuarios)this.repoUsuario.findById((Object)dto.getIdUsuario()).orElseThrow(() -> new RuntimeException("Usuario no encontrado"));
        entidad.setUsuario(usuario);
        if (dto.getIdProveedor() != null) {
            Proveedores proveedor = (Proveedores)this.repoProveedores.findById((Object)dto.getIdProveedor()).orElseThrow(() -> new RuntimeException("Proveedor no encontrado"));
            entidad.setProveedor(proveedor);
        }
        if (entidad.getTipo_movimiento() == MovimientosInventario.TipoMovimiento.Entrada && entidad.getProveedor() == null) {
            throw new RuntimeException("Se requiere un proveedor para los movimientos de 'Entrada'");
        }
        return entidad;
    }
}

