/*
 * Decompiled with CFR 0.152.
 */
package web.Regional_Api.controller;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import web.Regional_Api.entity.PagoSuscripcionDTO;
import web.Regional_Api.service.PagoSuscripcionService;

@RestController
@RequestMapping(value={"/api/pagos-suscripcion"})
public class PagoSuscripcionController {
    @Autowired
    private PagoSuscripcionService pagoService;
    private final DateTimeFormatter dateFormatter = DateTimeFormatter.ISO_LOCAL_DATE_TIME;

    @GetMapping
    public ResponseEntity<List<PagoSuscripcionDTO>> obtenerTodos() {
        List pagos = this.pagoService.obtenerTodos();
        return ResponseEntity.ok((Object)pagos);
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<PagoSuscripcionDTO> obtenerPorId(@PathVariable Long id) {
        PagoSuscripcionDTO pago = this.pagoService.obtenerPorId(id);
        if (pago != null) {
            return ResponseEntity.ok((Object)pago);
        }
        return ResponseEntity.notFound().build();
    }

    @GetMapping(value={"/restaurante/{idRestaurante}"})
    public ResponseEntity<List<PagoSuscripcionDTO>> obtenerPagosPorRestaurante(@PathVariable Integer idRestaurante) {
        List pagos = this.pagoService.obtenerPagosPorRestaurante(idRestaurante);
        return ResponseEntity.ok((Object)pagos);
    }

    @GetMapping(value={"/restaurante/{idRestaurante}/ultimo"})
    public ResponseEntity<PagoSuscripcionDTO> obtenerUltimoPago(@PathVariable Integer idRestaurante) {
        PagoSuscripcionDTO pago = this.pagoService.obtenerUltimoPago(idRestaurante);
        if (pago != null) {
            return ResponseEntity.ok((Object)pago);
        }
        return ResponseEntity.notFound().build();
    }

    @GetMapping(value={"/filtro/pendientes"})
    public ResponseEntity<List<PagoSuscripcionDTO>> obtenerPagosPendientes() {
        List pagos = this.pagoService.obtenerPagosPendientes();
        return ResponseEntity.ok((Object)pagos);
    }

    @GetMapping(value={"/filtro/estado"})
    public ResponseEntity<List<PagoSuscripcionDTO>> obtenerPagosPorEstado(@RequestParam String estado) {
        List pagos = this.pagoService.obtenerPagosPorEstado(estado);
        return ResponseEntity.ok((Object)pagos);
    }

    @GetMapping(value={"/restaurante/{idRestaurante}/estado"})
    public ResponseEntity<List<PagoSuscripcionDTO>> obtenerPagosRestaurantePorEstado(@PathVariable Integer idRestaurante, @RequestParam String estado) {
        List pagos = this.pagoService.obtenerPagosRestaurantePorEstado(idRestaurante, estado);
        return ResponseEntity.ok((Object)pagos);
    }

    @GetMapping(value={"/filtro/fecha"})
    public ResponseEntity<List<PagoSuscripcionDTO>> obtenerPagosPorFecha(@RequestParam String desde, @RequestParam String hasta) {
        LocalDateTime desdeDate = LocalDateTime.parse(desde, this.dateFormatter);
        LocalDateTime hastaDate = LocalDateTime.parse(hasta, this.dateFormatter);
        List pagos = this.pagoService.obtenerPagosPorFecha(desdeDate, hastaDate);
        return ResponseEntity.ok((Object)pagos);
    }

    @GetMapping(value={"/estadisticas/pendientes-count"})
    public ResponseEntity<Long> contarPagosPendientes() {
        long count = this.pagoService.contarPagosPendientes();
        return ResponseEntity.ok((Object)count);
    }

    @PostMapping(value={"/restaurante/{idRestaurante}"})
    public ResponseEntity<PagoSuscripcionDTO> crearPago(@PathVariable Integer idRestaurante, @RequestBody PagoSuscripcionDTO dto) {
        try {
            PagoSuscripcionDTO pago = this.pagoService.crearPago(idRestaurante, dto);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)pago);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            return ResponseEntity.badRequest().build();
        }
    }

    @PutMapping(value={"/{id}/aprobar"})
    public ResponseEntity<PagoSuscripcionDTO> aprobarPago(@PathVariable Long id) {
        try {
            PagoSuscripcionDTO pago = this.pagoService.aprobarPago(id);
            return ResponseEntity.ok((Object)pago);
        }
        catch (RuntimeException e) {
            return ResponseEntity.notFound().build();
        }
    }

    @PutMapping(value={"/{id}/rechazar"})
    public ResponseEntity<PagoSuscripcionDTO> rechazarPago(@PathVariable Long id, @RequestParam String motivo) {
        try {
            PagoSuscripcionDTO pago = this.pagoService.rechazarPago(id, motivo);
            return ResponseEntity.ok((Object)pago);
        }
        catch (RuntimeException e) {
            return ResponseEntity.notFound().build();
        }
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<PagoSuscripcionDTO> actualizarPago(@PathVariable Long id, @RequestBody PagoSuscripcionDTO dto) {
        try {
            PagoSuscripcionDTO pago = this.pagoService.actualizarPago(id, dto);
            return ResponseEntity.ok((Object)pago);
        }
        catch (RuntimeException e) {
            return ResponseEntity.badRequest().build();
        }
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Void> eliminarPago(@PathVariable Long id) {
        try {
            this.pagoService.eliminarPago(id);
            return ResponseEntity.noContent().build();
        }
        catch (Exception e) {
            return ResponseEntity.notFound().build();
        }
    }
}

