/*
 * Decompiled with CFR 0.152.
 */
package web.Regional_Api.controller;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import web.Regional_Api.entity.Pedido;
import web.Regional_Api.service.IPedidoService;

@RestController
@RequestMapping(value={"/api/pedidos"})
public class PedidoController {
    @Autowired
    private IPedidoService pedidoService;

    @GetMapping
    public ResponseEntity<List<Pedido>> buscarTodos() {
        try {
            List pedidos = this.pedidoService.buscarTodos();
            return new ResponseEntity((Object)pedidos, (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<Pedido> buscarPorId(@PathVariable Integer id) {
        try {
            Optional pedido = this.pedidoService.buscarId(id);
            if (pedido.isPresent()) {
                return new ResponseEntity((Object)((Pedido)pedido.get()), (HttpStatusCode)HttpStatus.OK);
            }
            return ResponseEntity.notFound().build();
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
    }

    @PostMapping
    public ResponseEntity<Pedido> guardar(@RequestBody Pedido pedido) {
        try {
            Pedido pedidoGuardado = this.pedidoService.guardar(pedido);
            return new ResponseEntity((Object)pedidoGuardado, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (Exception e) {
            return ResponseEntity.badRequest().build();
        }
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<Pedido> modificar(@PathVariable Integer id, @RequestBody Pedido pedido) {
        try {
            pedido.setIdPedido(id);
            Pedido pedidoModificado = this.pedidoService.modificar(pedido);
            return new ResponseEntity((Object)pedidoModificado, (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            return ResponseEntity.badRequest().build();
        }
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<String> eliminar(@PathVariable Integer id) {
        try {
            this.pedidoService.eliminar(id);
            return new ResponseEntity((Object)"Pedido cancelado correctamente", (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            return new ResponseEntity((Object)"Error al cancelar pedido", (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @GetMapping(value={"/sucursal/{idSucursal}"})
    public ResponseEntity<List<Pedido>> buscarPorSucursal(@PathVariable Integer idSucursal) {
        try {
            List pedidos = this.pedidoService.buscarPorSucursal(idSucursal);
            return new ResponseEntity((Object)pedidos, (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GetMapping(value={"/estado/{estadoPedido}"})
    public ResponseEntity<List<Pedido>> buscarPorEstado(@PathVariable String estadoPedido) {
        try {
            List pedidos = this.pedidoService.buscarPorEstado(estadoPedido);
            return new ResponseEntity((Object)pedidos, (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GetMapping(value={"/usuario/{idUsuario}"})
    public ResponseEntity<List<Pedido>> buscarPorUsuario(@PathVariable Integer idUsuario) {
        try {
            List pedidos = this.pedidoService.buscarPorUsuario(idUsuario);
            return new ResponseEntity((Object)pedidos, (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GetMapping(value={"/mesa/{idMesa}"})
    public ResponseEntity<List<Pedido>> buscarPorMesa(@PathVariable Integer idMesa) {
        try {
            List pedidos = this.pedidoService.buscarPorMesa(idMesa);
            return new ResponseEntity((Object)pedidos, (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GetMapping(value={"/tipo/{tipoPedido}"})
    public ResponseEntity<List<Pedido>> buscarPorTipoPedido(@PathVariable String tipoPedido) {
        try {
            List pedidos = this.pedidoService.buscarPorTipoPedido(tipoPedido);
            return new ResponseEntity((Object)pedidos, (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GetMapping(value={"/fechas"})
    public ResponseEntity<List<Pedido>> buscarPorFecha(@RequestParam @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) LocalDateTime fechaInicio, @RequestParam @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) LocalDateTime fechaFin) {
        try {
            List pedidos = this.pedidoService.buscarPorFecha(fechaInicio, fechaFin);
            return new ResponseEntity((Object)pedidos, (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GetMapping(value={"/sucursal/{idSucursal}/estado/{estadoPedido}"})
    public ResponseEntity<List<Pedido>> buscarPorSucursalYEstado(@PathVariable Integer idSucursal, @PathVariable String estadoPedido) {
        try {
            List pedidos = this.pedidoService.buscarPorSucursalYEstado(idSucursal, estadoPedido);
            return new ResponseEntity((Object)pedidos, (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GetMapping(value={"/sucursal/{idSucursal}/activos"})
    public ResponseEntity<List<Pedido>> buscarPedidosActivos(@PathVariable Integer idSucursal) {
        try {
            List pedidos = this.pedidoService.buscarPedidosActivos(idSucursal);
            return new ResponseEntity((Object)pedidos, (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GetMapping(value={"/cliente/{nombreCliente}"})
    public ResponseEntity<List<Pedido>> buscarPorNombreCliente(@PathVariable String nombreCliente) {
        try {
            List pedidos = this.pedidoService.buscarPorNombreCliente(nombreCliente);
            return new ResponseEntity((Object)pedidos, (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GetMapping(value={"/mesa/{idMesa}/ultimo-activo"})
    public ResponseEntity<Pedido> buscarUltimoPedidoActivoByMesa(@PathVariable Integer idMesa) {
        try {
            Optional pedido = this.pedidoService.buscarUltimoPedidoActivoByMesa(idMesa);
            if (pedido.isPresent()) {
                return new ResponseEntity((Object)((Pedido)pedido.get()), (HttpStatusCode)HttpStatus.OK);
            }
            return ResponseEntity.notFound().build();
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
    }
}

