/*
 * Decompiled with CFR 0.152.
 */
package web.Regional_Api.controller;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import web.Regional_Api.entity.Categoria;
import web.Regional_Api.entity.Plato;
import web.Regional_Api.entity.PlatoDTO;
import web.Regional_Api.entity.Sucursales;
import web.Regional_Api.repository.CategoriaRepository;
import web.Regional_Api.repository.PlatoRepository;
import web.Regional_Api.repository.SucursalesRepository;

@RestController
@RequestMapping(value={"/api/platos"})
public class PlatoController {
    @Autowired
    private PlatoRepository platoRepository;
    @Autowired
    private CategoriaRepository categoriaRepository;
    @Autowired
    private SucursalesRepository sucursalesRepository;

    @GetMapping
    public ResponseEntity<List<PlatoDTO>> obtenerTodos() {
        List platos = this.platoRepository.findAll().stream().map(arg_0 -> this.convertirADTO(arg_0)).collect(Collectors.toList());
        return ResponseEntity.ok(platos);
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<PlatoDTO> obtenerPorId(@PathVariable Integer id) {
        Optional plato = this.platoRepository.findById((Object)id);
        return plato.map(arg_0 -> this.convertirADTO(arg_0)).map(ResponseEntity::ok).orElseGet(() -> ResponseEntity.notFound().build());
    }

    @GetMapping(value={"/categoria/{id_categoria}"})
    public ResponseEntity<List<PlatoDTO>> obtenerPorCategoria(@PathVariable Integer id_categoria) {
        List platos = this.platoRepository.buscarPorCategoria(id_categoria).stream().map(arg_0 -> this.convertirADTO(arg_0)).collect(Collectors.toList());
        return ResponseEntity.ok(platos);
    }

    @GetMapping(value={"/categoria/{id_categoria}/disponibles"})
    public ResponseEntity<List<PlatoDTO>> obtenerDisponiblesPorCategoria(@PathVariable Integer id_categoria) {
        List platos = this.platoRepository.platosDisponiblesPorCategoria(id_categoria).stream().map(arg_0 -> this.convertirADTO(arg_0)).collect(Collectors.toList());
        return ResponseEntity.ok(platos);
    }

    @GetMapping(value={"/buscar"})
    public ResponseEntity<List<PlatoDTO>> buscar(@RequestParam String nombre) {
        List platos = this.platoRepository.buscarPorNombre(nombre).stream().map(arg_0 -> this.convertirADTO(arg_0)).collect(Collectors.toList());
        return ResponseEntity.ok(platos);
    }

    @PostMapping
    public ResponseEntity<PlatoDTO> crear(@RequestBody PlatoDTO platoDTO) {
        if (platoDTO.getId_categoria() == null) {
            return ResponseEntity.badRequest().body(null);
        }
        Optional categoriaOpt = this.categoriaRepository.findById((Object)platoDTO.getId_categoria());
        if (categoriaOpt.isEmpty()) {
            return ResponseEntity.badRequest().build();
        }
        if (platoDTO.getId_sucursal() == null) {
            return ResponseEntity.badRequest().body(null);
        }
        Optional sucursalOpt = this.sucursalesRepository.findById((Object)platoDTO.getId_sucursal());
        if (sucursalOpt.isEmpty()) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body(null);
        }
        Plato plato = new Plato();
        plato.setNombre(platoDTO.getNombre());
        plato.setDescripcion(platoDTO.getDescripcion());
        plato.setPrecio(platoDTO.getPrecio());
        plato.setCategoria((Categoria)categoriaOpt.get());
        plato.setSucursales((Sucursales)sucursalOpt.get());
        plato.setEstado(Integer.valueOf(1));
        Plato guardado = (Plato)this.platoRepository.save((Object)plato);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)this.convertirADTO(guardado));
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<PlatoDTO> actualizar(@PathVariable Integer id, @RequestBody PlatoDTO platoDTO) {
        Optional optional = this.platoRepository.findById((Object)id);
        if (optional.isEmpty()) {
            return ResponseEntity.notFound().build();
        }
        Plato plato = (Plato)optional.get();
        if (platoDTO.getNombre() != null) {
            plato.setNombre(platoDTO.getNombre());
        }
        if (platoDTO.getDescripcion() != null) {
            plato.setDescripcion(platoDTO.getDescripcion());
        }
        if (platoDTO.getPrecio() != null) {
            plato.setPrecio(platoDTO.getPrecio());
        }
        Plato actualizado = (Plato)this.platoRepository.save((Object)plato);
        return ResponseEntity.ok((Object)this.convertirADTO(actualizado));
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Void> eliminar(@PathVariable Integer id) {
        Optional optional = this.platoRepository.findById((Object)id);
        if (optional.isEmpty()) {
            return ResponseEntity.notFound().build();
        }
        Plato plato = (Plato)optional.get();
        plato.setEstado(Integer.valueOf(0));
        this.platoRepository.save((Object)plato);
        return ResponseEntity.noContent().build();
    }

    private PlatoDTO convertirADTO(Plato entidad) {
        PlatoDTO dto = new PlatoDTO();
        dto.setId_plato(entidad.getId_plato());
        dto.setNombre(entidad.getNombre());
        dto.setDescripcion(entidad.getDescripcion());
        dto.setPrecio(entidad.getPrecio());
        dto.setEstado(entidad.getEstado());
        if (entidad.getCategoria() != null) {
            dto.setId_categoria(entidad.getCategoria().getId_categoria());
        }
        if (entidad.getSucursales() != null) {
            dto.setId_sucursal(entidad.getSucursales().getIdSucursal());
        }
        return dto;
    }
}

