/*
 * Decompiled with CFR 0.152.
 */
package web.Regional_Api.controller;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import web.Regional_Api.entity.Proveedores;
import web.Regional_Api.entity.ProveedoresDTO;
import web.Regional_Api.entity.Restaurante;
import web.Regional_Api.repository.RestauranteRepository;
import web.Regional_Api.service.IProveedoresService;

@RestController
@RequestMapping(value={"/regional/proveedores"})
public class ProveedoresController {
    @Autowired
    private IProveedoresService serviceProveedores;
    @Autowired
    private RestauranteRepository repoRestaurante;

    @GetMapping
    public List<ProveedoresDTO> buscarTodos() {
        return this.serviceProveedores.buscarTodos().stream().map(arg_0 -> this.convertirADTO(arg_0)).collect(Collectors.toList());
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<ProveedoresDTO> buscarPorId(@PathVariable Integer id) {
        return this.serviceProveedores.buscarId(id).map(arg_0 -> this.convertirADTO(arg_0)).map(ResponseEntity::ok).orElse(ResponseEntity.notFound().build());
    }

    @PostMapping
    public ResponseEntity<?> guardar(@RequestBody ProveedoresDTO dto) {
        try {
            Proveedores entidad = this.convertirAEntidad(dto);
            Proveedores entidadGuardada = this.serviceProveedores.guardar(entidad);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)this.convertirADTO(entidadGuardada));
        }
        catch (RuntimeException e) {
            Map<String, String> error = Map.of("success", "false", "message", e.getMessage());
            return ResponseEntity.badRequest().body(error);
        }
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<ProveedoresDTO> modificar(@PathVariable Integer id, @RequestBody ProveedoresDTO dto) {
        return this.serviceProveedores.buscarId(id).map(entidadExistente -> {
            try {
                entidadExistente.setNombre(dto.getNombre());
                entidadExistente.setRuc(dto.getRuc());
                entidadExistente.setContacto_nombre(dto.getContacto_nombre());
                entidadExistente.setContacto_telefono(dto.getContacto_telefono());
                entidadExistente.setEstado(dto.getEstado());
                if (dto.getIdRestaurante() != null) {
                    Restaurante restaurante = (Restaurante)this.repoRestaurante.findById((Object)dto.getIdRestaurante()).orElseThrow(() -> new RuntimeException("Restaurante no encontrado"));
                    entidadExistente.setId_restaurante(restaurante);
                }
                Proveedores entidadActualizada = this.serviceProveedores.modificar(entidadExistente);
                return ResponseEntity.ok((Object)this.convertirADTO(entidadActualizada));
            }
            catch (RuntimeException e) {
                return ResponseEntity.badRequest().build();
            }
        }).orElse(ResponseEntity.notFound().build());
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Void> eliminar(@PathVariable Integer id) {
        Optional optionalProveedor = this.serviceProveedores.buscarId(id);
        if (optionalProveedor.isEmpty()) {
            return ResponseEntity.notFound().build();
        }
        this.serviceProveedores.eliminar(id);
        return ResponseEntity.noContent().build();
    }

    private ProveedoresDTO convertirADTO(Proveedores entidad) {
        ProveedoresDTO dto = new ProveedoresDTO();
        dto.setId_proveedor(entidad.getId_proveedor());
        dto.setNombre(entidad.getNombre());
        dto.setRuc(entidad.getRuc());
        dto.setContacto_nombre(entidad.getContacto_nombre());
        dto.setContacto_telefono(entidad.getContacto_telefono());
        dto.setEstado(entidad.getEstado());
        if (entidad.getId_restaurante() != null) {
            dto.setIdRestaurante(entidad.getId_restaurante().getIdRestaurante());
        }
        return dto;
    }

    private Proveedores convertirAEntidad(ProveedoresDTO dto) {
        Proveedores entidad = new Proveedores();
        entidad.setId_proveedor(dto.getId_proveedor());
        entidad.setNombre(dto.getNombre());
        entidad.setRuc(dto.getRuc());
        entidad.setContacto_nombre(dto.getContacto_nombre());
        entidad.setContacto_telefono(dto.getContacto_telefono());
        entidad.setEstado(Integer.valueOf(dto.getEstado() != null ? dto.getEstado() : 1));
        if (dto.getIdRestaurante() == null) {
            throw new RuntimeException("Es obligatorio proveer un idRestaurante");
        }
        Restaurante restaurante = (Restaurante)this.repoRestaurante.findById((Object)dto.getIdRestaurante()).orElseThrow(() -> new RuntimeException("Restaurante no encontrado con ID: " + String.valueOf(dto.getIdRestaurante())));
        entidad.setId_restaurante(restaurante);
        return entidad;
    }
}

