/*
 * Decompiled with CFR 0.152.
 */
package web.Regional_Api.controller;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import web.Regional_Api.entity.Registros;
import web.Regional_Api.security.JwtUtil;
import web.Regional_Api.service.IRegistrosService;

@RestController
@RequestMapping(value={"/restful"})
public class RegistrosController {
    @Autowired
    private IRegistrosService serviceRegistro;
    @Autowired
    private JwtUtil jwtUtil;
    @Autowired
    private BCryptPasswordEncoder passwordEncoder;

    @GetMapping(value={"/registros"})
    public List<Registros> buscarTodos() {
        return this.serviceRegistro.buscarTodos();
    }

    @PostMapping(value={"/registros"})
    public Registros guardar(@RequestBody Registros registro) {
        registro.setid_usuario(null);
        String claveOriginal = registro.getEmail() + registro.getNombres() + registro.getApellidos();
        registro.setLlave_secreta(claveOriginal);
        this.serviceRegistro.guardar(registro);
        return registro;
    }

    @PutMapping(value={"/registros"})
    public Registros modificar(@RequestBody Registros registro) {
        this.serviceRegistro.modificar(registro);
        return registro;
    }

    @GetMapping(value={"/registros/{id}"})
    public Optional<Registros> buscarId(@PathVariable(value="id") Integer id) {
        return this.serviceRegistro.buscarId(id);
    }

    @DeleteMapping(value={"/registros/{id}"})
    public String eliminar(@PathVariable Integer id) {
        this.serviceRegistro.eliminar(id);
        return "Registro eliminado";
    }

    @PostMapping(value={"/token"})
    public ResponseEntity<?> obtenerToken(@RequestBody Map<String, String> credenciales) {
        String usuarioId = credenciales.get("id_usuario");
        String llaveSecreta = credenciales.get("llave_secreta");
        Optional<Registros> user = this.serviceRegistro.buscarTodos().stream().filter(r -> r.getid_usuario().equals(usuarioId)).findFirst();
        if (user.isPresent() && this.passwordEncoder.matches((CharSequence)llaveSecreta, user.get().getLlave_secreta())) {
            String token = this.jwtUtil.generarToken(usuarioId);
            if (token == null || token.trim().isEmpty()) {
                token = "default_access_token";
            }
            Registros registros = user.get();
            registros.setAccess_token(token);
            try {
                this.serviceRegistro.guardar(registros);
            }
            catch (IllegalArgumentException ex) {
                return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)ex.getMessage());
            }
            String responseToken = token.equals("default_access_token") ? "" : token;
            return ResponseEntity.ok(Collections.singletonMap("token", responseToken));
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).body((Object)"Credenciales Incorrectas");
    }
}

