/*
 * Decompiled with CFR 0.152.
 */
package web.Regional_Api.controller;

import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import web.Regional_Api.entity.ReporteDTO;
import web.Regional_Api.service.IReporteService;

@RestController
@RequestMapping(value={"/restful/superadmin/reportes"})
@CrossOrigin(originPatterns={"*"}, allowCredentials="true")
public class ReporteController {
    @Autowired
    private IReporteService reporteService;

    @GetMapping
    public ResponseEntity<List<ReporteDTO>> getAllReportes() {
        List reportes = this.reporteService.obtenerTodos();
        List dtos = reportes.stream().map(ReporteDTO::new).collect(Collectors.toList());
        return ResponseEntity.ok(dtos);
    }

    @GetMapping(value={"/superadmin/{id}"})
    public ResponseEntity<List<ReporteDTO>> getBySuperAdmin(@PathVariable Integer id) {
        List reportes = this.reporteService.obtenerPorSuperAdmin(id);
        List dtos = reportes.stream().map(ReporteDTO::new).collect(Collectors.toList());
        return ResponseEntity.ok(dtos);
    }
}

