/*
 * Decompiled with CFR 0.152.
 */
package web.Regional_Api.controller;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import web.Regional_Api.entity.RestauranteDTO;
import web.Regional_Api.service.RestauranteService;

@RestController
@RequestMapping(value={"/api/restaurantes"})
public class RestauranteController {
    @Autowired
    private RestauranteService restauranteService;

    @GetMapping
    public ResponseEntity<List<RestauranteDTO>> obtenerTodos() {
        List restaurantes = this.restauranteService.obtenerTodos();
        return ResponseEntity.ok((Object)restaurantes);
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<RestauranteDTO> obtenerPorId(@PathVariable Integer id) {
        RestauranteDTO restaurante = this.restauranteService.obtenerPorId(id);
        if (restaurante != null) {
            return ResponseEntity.ok((Object)restaurante);
        }
        return ResponseEntity.notFound().build();
    }

    @GetMapping(value={"/ruc/{ruc}"})
    public ResponseEntity<RestauranteDTO> obtenerPorRuc(@PathVariable String ruc) {
        RestauranteDTO restaurante = this.restauranteService.obtenerPorRuc(ruc);
        if (restaurante != null) {
            return ResponseEntity.ok((Object)restaurante);
        }
        return ResponseEntity.notFound().build();
    }

    @GetMapping(value={"/buscar/nombre"})
    public ResponseEntity<List<RestauranteDTO>> buscarPorNombre(@RequestParam String nombre) {
        List restaurantes = this.restauranteService.buscarPorNombre(nombre);
        return ResponseEntity.ok((Object)restaurantes);
    }

    @GetMapping(value={"/filtro/activos"})
    public ResponseEntity<List<RestauranteDTO>> obtenerActivos() {
        List restaurantes = this.restauranteService.obtenerActivos();
        return ResponseEntity.ok((Object)restaurantes);
    }

    @GetMapping(value={"/filtro/vencidos"})
    public ResponseEntity<List<RestauranteDTO>> obtenerConSuscripcionVencida() {
        List restaurantes = this.restauranteService.obtenerConSuscripcionVencida();
        return ResponseEntity.ok((Object)restaurantes);
    }

    @GetMapping(value={"/filtro/proximo-vencimiento"})
    public ResponseEntity<List<RestauranteDTO>> obtenerProximoVencimiento(@RequestParam Integer dias) {
        List restaurantes = this.restauranteService.obtenerProximoVencimiento(dias);
        return ResponseEntity.ok((Object)restaurantes);
    }

    @PostMapping
    public ResponseEntity<RestauranteDTO> crearRestaurante(@RequestBody RestauranteDTO dto) {
        try {
            RestauranteDTO restaurante = this.restauranteService.crearRestaurante(dto);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)restaurante);
        }
        catch (RuntimeException e) {
            return ResponseEntity.badRequest().build();
        }
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<RestauranteDTO> actualizarRestaurante(@PathVariable Integer id, @RequestBody RestauranteDTO dto) {
        try {
            RestauranteDTO restaurante = this.restauranteService.actualizarRestaurante(id, dto);
            return ResponseEntity.ok((Object)restaurante);
        }
        catch (RuntimeException e) {
            return ResponseEntity.notFound().build();
        }
    }

    @PutMapping(value={"/{id}/estado"})
    public ResponseEntity<RestauranteDTO> cambiarEstado(@PathVariable Integer id, @RequestParam Integer estado) {
        try {
            RestauranteDTO restaurante = this.restauranteService.cambiarEstado(id, estado);
            return ResponseEntity.ok((Object)restaurante);
        }
        catch (RuntimeException e) {
            return ResponseEntity.notFound().build();
        }
    }

    @PutMapping(value={"/{id}/renovar-suscripcion"})
    public ResponseEntity<RestauranteDTO> renovarSuscripcion(@PathVariable Integer id, @RequestParam Integer dias) {
        try {
            RestauranteDTO restaurante = this.restauranteService.renovarSuscripcion(id, dias);
            return ResponseEntity.ok((Object)restaurante);
        }
        catch (RuntimeException e) {
            return ResponseEntity.notFound().build();
        }
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Void> eliminarRestaurante(@PathVariable Integer id) {
        try {
            this.restauranteService.eliminarRestaurante(id);
            return ResponseEntity.noContent().build();
        }
        catch (Exception e) {
            return ResponseEntity.notFound().build();
        }
    }
}

