/*
 * Decompiled with CFR 0.152.
 */
package web.Regional_Api.controller;

import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import web.Regional_Api.entity.SesionesCaja;
import web.Regional_Api.service.ISesionesCajaService;

@RestController
@RequestMapping(value={"/restful"})
public class SesionesCajaController {
    @Autowired
    private ISesionesCajaService serviceSesiones;

    @GetMapping(value={"/caja/todos"})
    public List<SesionesCaja> buscarTodasSinFiltro() {
        return this.serviceSesiones.buscarTodas();
    }

    @GetMapping(value={"/caja"})
    public List<SesionesCaja> buscarTodas() {
        Integer idSucursalFijo = 1;
        return this.serviceSesiones.buscarTodasPorSucursal(idSucursalFijo);
    }

    public Optional<SesionesCaja> buscarAbierta() {
        Integer idSucursalFijo = 1;
        return this.serviceSesiones.buscarSesionAbiertaPorSucursal(idSucursalFijo);
    }

    @PostMapping(value={"/caja"})
    public SesionesCaja abrirCaja(@RequestBody SesionesCaja sesion) {
        this.serviceSesiones.abrirCaja(sesion);
        return sesion;
    }

    @PutMapping(value={"/caja"})
    public SesionesCaja cerrarCaja(@RequestBody SesionesCaja sesionCierre) {
        this.serviceSesiones.cerrarCaja(sesionCierre);
        return sesionCierre;
    }

    @DeleteMapping(value={"/caja/{id}"})
    public String eliminar(@PathVariable Integer id) {
        this.serviceSesiones.eliminar(id);
        return "Sesi\u00f3n eliminada";
    }
}

