/*
 * Decompiled with CFR 0.152.
 */
package web.Regional_Api.controller;

import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import web.Regional_Api.entity.Sucursales;
import web.Regional_Api.service.ISucursalesService;
import web.Regional_Api.service.jpa.UsuarioService;

@RestController
@RequestMapping(value={"/restful"})
public class SucursalesController {
    @Autowired
    private ISucursalesService serviceSucursales;
    @Autowired
    private UsuarioService usuarioService;

    @GetMapping(value={"/sucursales/todos"})
    public List<Sucursales> buscarTodasSinFiltro() {
        return this.serviceSucursales.buscarTodos();
    }

    @GetMapping(value={"/sucursales"})
    public List<Sucursales> buscarTodosFiltradoPorRestaurante() {
        Integer idRestauranteFijo = 1;
        return this.serviceSucursales.buscarTodosPorRestaurante(idRestauranteFijo);
    }

    @GetMapping(value={"/sucursales/{id}"})
    public Optional<Sucursales> buscarId(@PathVariable(value="id") Integer idSucursal) {
        return this.serviceSucursales.buscarId(idSucursal);
    }

    @PostMapping(value={"/sucursales"})
    public Sucursales guardar(@RequestBody Sucursales sucursal) {
        return this.serviceSucursales.guardar(sucursal);
    }

    @PutMapping(value={"/sucursales"})
    public Sucursales modificar(@RequestBody Sucursales sucursalActualizada) {
        this.serviceSucursales.modificar(sucursalActualizada);
        return sucursalActualizada;
    }

    @DeleteMapping(value={"/sucursales/{id}"})
    public String eliminar(@PathVariable Integer id) {
        this.serviceSucursales.eliminar(id);
        return "Sucursal eliminada";
    }
}

