/*
 * Decompiled with CFR 0.152.
 */
package web.Regional_Api.controller;

import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.LocalDateTime;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import web.Regional_Api.entity.Acceso;
import web.Regional_Api.entity.BitacoraAccion;
import web.Regional_Api.entity.Modulo;
import web.Regional_Api.entity.Perfil;
import web.Regional_Api.entity.Restaurante;
import web.Regional_Api.entity.RestauranteDTO;
import web.Regional_Api.entity.Sucursales;
import web.Regional_Api.entity.SuperAdmin;
import web.Regional_Api.entity.Usuarios;
import web.Regional_Api.security.SuperAdminJwtUtil;
import web.Regional_Api.service.EmailService;
import web.Regional_Api.service.IReporteService;
import web.Regional_Api.service.ISuperAdminService;
import web.Regional_Api.service.RestauranteService;
import web.Regional_Api.service.jpa.AccesoService;
import web.Regional_Api.service.jpa.BitacoraService;
import web.Regional_Api.service.jpa.ModuloService;
import web.Regional_Api.service.jpa.PerfilService;
import web.Regional_Api.service.jpa.SucursalesService;
import web.Regional_Api.service.jpa.UsuarioService;

@RestController
@RequestMapping(value={"/restful/superadmin"})
public class SuperAdminController {
    @Autowired
    private SuperAdminJwtUtil jwtUtil;
    @Autowired
    private PerfilService perfilService;
    @Autowired
    private ModuloService moduloService;
    @Autowired
    private AccesoService accesoService;
    @Autowired
    private RestauranteService restauranteService;
    @Autowired
    private ISuperAdminService superAdminService;
    @Autowired
    private EmailService emailService;
    @Autowired
    private PasswordEncoder passwordEncoder;
    @Autowired
    private UsuarioService usuarioService;
    @Autowired
    private IReporteService reporteService;
    @Autowired
    private SucursalesService sucursalesService;
    @Autowired
    private BitacoraService bitacoraService;

    @PostMapping(value={"/auth/initiate-login"})
    public ResponseEntity<?> initiateLogin(@RequestBody Map<String, String> loginRequest) {
        String email = loginRequest.get("email");
        String password = loginRequest.get("password");
        if (email == null || password == null) {
            return ResponseEntity.badRequest().body((Object)"Email y contrase\u00f1a requeridos");
        }
        Optional adminOpt = this.superAdminService.getSuperAdminByEmail(email);
        if (adminOpt.isEmpty()) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).body((Object)"Credenciales inv\u00e1lidas");
        }
        SuperAdmin admin = (SuperAdmin)adminOpt.get();
        String hashedPassword = this.hashPassword(password);
        if (!hashedPassword.equals(admin.getPassword())) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).body((Object)"Credenciales inv\u00e1lidas");
        }
        if (admin.getEstado() == null || admin.getEstado() != 1) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).body((Object)"SuperAdmin inactivo");
        }
        String token = this.jwtUtil.generateToken(admin.getEmail());
        admin.setTokenLogin(token);
        String oldPassword = admin.getPassword();
        admin.setPassword(null);
        this.superAdminService.updateSuperAdmin(admin.getIdSuperAdmin(), admin);
        admin.setPassword(oldPassword);
        HashMap<String, String> response = new HashMap<String, String>();
        response.put("token", token);
        try {
            this.emailService.enviarTokenSuperAdmin(email, token, admin.getNombres());
            System.out.println("\ud83d\udce7 Token enviado al correo: " + email);
        }
        catch (Exception emailEx) {
            System.err.println("\u26a0\ufe0f Error al enviar email (login contin\u00faa): " + emailEx.getMessage());
        }
        return ResponseEntity.ok(response);
    }

    private String hashPassword(String password) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] hash = digest.digest(password.getBytes(StandardCharsets.UTF_8));
            return Base64.getEncoder().encodeToString(hash);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Error al generar hash de contrase\u00f1a", e);
        }
    }

    private String hashPasswordHex(String plainPassword) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(plainPassword.getBytes(StandardCharsets.UTF_8));
            byte[] digest = md.digest();
            BigInteger result = new BigInteger(1, digest);
            Object hash = result.toString(16).toUpperCase();
            while (((String)hash).length() < 64) {
                hash = "0" + (String)hash;
            }
            return hash;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Error al encriptar la contrase\u00f1a", e);
        }
    }

    @PostMapping(value={"/auth/login"})
    public ResponseEntity<?> loginSuperAdmin(@RequestBody Map<String, String> request) {
        String token = request.get("token");
        System.out.println("Intento de login SuperAdmin con token: " + token);
        if (token == null || token.isEmpty()) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)"Token requerido");
        }
        Optional superAdminOpt = this.superAdminService.getSuperAdminByToken(token);
        if (superAdminOpt.isEmpty()) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).body((Object)"Token inv\u00e1lido o no encontrado");
        }
        SuperAdmin superAdmin = (SuperAdmin)superAdminOpt.get();
        if (superAdmin.getEstado() == null || superAdmin.getEstado() != 1) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.FORBIDDEN).body((Object)"Cuenta inactiva o eliminada");
        }
        String jwt = this.jwtUtil.generarToken(superAdmin.getEmail());
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("token", jwt);
        response.put("idUsuario", superAdmin.getIdSuperAdmin());
        response.put("nombres", superAdmin.getNombres());
        response.put("email", superAdmin.getEmail());
        response.put("rol", superAdmin.getRol());
        response.put("nombrePerfil", "Super Administrador");
        response.put("idSucursal", 0);
        HashMap<String, Object> user = new HashMap<String, Object>();
        user.put("id_superadmin", superAdmin.getIdSuperAdmin());
        user.put("nombres", superAdmin.getNombres());
        user.put("email", superAdmin.getEmail());
        user.put("rol", superAdmin.getRol());
        response.put("user", user);
        System.out.println("Login SuperAdmin exitoso: " + superAdmin.getEmail());
        return ResponseEntity.ok(response);
    }

    @GetMapping(value={"/estadisticas"})
    public ResponseEntity<?> getEstadisticas() {
        HashMap<String, Object> stats = new HashMap<String, Object>();
        stats.put("totalRestaurantes", this.restauranteService.contarTodos());
        stats.put("totalPerfiles", this.perfilService.getAllPerfiles().size());
        stats.put("totalModulos", this.moduloService.getAllModulos().size());
        List admins = this.superAdminService.getAllSuperAdmins();
        stats.put("totalSuperAdmins", admins.size());
        stats.put("superAdminsActivos", admins.stream().filter(a -> a.getEstado() == 1).count());
        Map<String, Long> porRol = admins.stream().collect(Collectors.groupingBy(SuperAdmin::getRol, Collectors.counting()));
        stats.put("superAdminsPorRol", porRol);
        return ResponseEntity.ok(stats);
    }

    @GetMapping(value={"/super-admins"})
    public ResponseEntity<List<SuperAdmin>> getAllSuperAdmins() {
        return ResponseEntity.ok((Object)this.superAdminService.getAllSuperAdmins());
    }

    @GetMapping(value={"/super-admins/{id}"})
    public ResponseEntity<?> getSuperAdminById(@PathVariable Integer id) {
        return this.superAdminService.getSuperAdminById(id).map(ResponseEntity::ok).orElse(ResponseEntity.notFound().build());
    }

    @PostMapping(value={"/super-admins"})
    public ResponseEntity<?> createSuperAdmin(@RequestBody SuperAdmin superAdmin) {
        try {
            Authentication auth = SecurityContextHolder.getContext().getAuthentication();
            boolean isMaster = auth.getAuthorities().stream().anyMatch(a -> a.getAuthority().equals("ROLE_MASTER"));
            if (!isMaster) {
                return ResponseEntity.status((HttpStatusCode)HttpStatus.FORBIDDEN).body((Object)"Acceso denegado: Solo el MASTER puede crear nuevos SuperAdmins.");
            }
            System.out.println("Creando nuevo SuperAdmin: " + superAdmin.getEmail());
            SuperAdmin created = this.superAdminService.createSuperAdmin(superAdmin);
            created.setPassword(null);
            Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
            this.superAdminService.getSuperAdminByEmail(authentication.getName()).ifPresent(admin -> this.reporteService.registrarAccion(admin, "CREAR_SUPERADMIN", "Cre\u00f3 SuperAdmin: " + created.getEmail(), "IP_PENDIENTE"));
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)created);
        }
        catch (RuntimeException e) {
            return ResponseEntity.badRequest().body((Object)e.getMessage());
        }
    }

    @PutMapping(value={"/super-admins/{id}"})
    public ResponseEntity<?> updateSuperAdmin(@PathVariable Integer id, @RequestBody SuperAdmin superAdmin) {
        try {
            Optional updated;
            if (superAdmin.getPassword() != null && !superAdmin.getPassword().isEmpty()) {
                System.out.println("Actualizando contrase\u00f1a para SuperAdmin ID: " + String.valueOf(id));
            }
            if ((updated = this.superAdminService.updateSuperAdmin(id, superAdmin)).isPresent()) {
                SuperAdmin result = (SuperAdmin)updated.get();
                result.setPassword(null);
                Authentication auth = SecurityContextHolder.getContext().getAuthentication();
                this.superAdminService.getSuperAdminByEmail(auth.getName()).ifPresent(admin -> this.reporteService.registrarAccion(admin, "ACTUALIZAR_SUPERADMIN", "Actualiz\u00f3 SuperAdmin ID: " + String.valueOf(id), "IP_PENDIENTE"));
                return ResponseEntity.ok((Object)result);
            }
            return ResponseEntity.notFound().build();
        }
        catch (RuntimeException e) {
            return ResponseEntity.badRequest().body((Object)e.getMessage());
        }
    }

    @DeleteMapping(value={"/super-admins/{id}"})
    public ResponseEntity<?> deleteSuperAdmin(@PathVariable Integer id) {
        try {
            this.superAdminService.deleteSuperAdmin(id);
            Authentication auth = SecurityContextHolder.getContext().getAuthentication();
            this.superAdminService.getSuperAdminByEmail(auth.getName()).ifPresent(admin -> this.reporteService.registrarAccion(admin, "ELIMINAR_SUPERADMIN", "Elimin\u00f3 SuperAdmin ID: " + String.valueOf(id), "IP_PENDIENTE"));
            return ResponseEntity.ok().build();
        }
        catch (RuntimeException e) {
            return ResponseEntity.notFound().build();
        }
    }

    @GetMapping(value={"/roles"})
    public ResponseEntity<List<Perfil>> getAllRoles() {
        return ResponseEntity.ok((Object)this.perfilService.getAllPerfiles());
    }

    @GetMapping(value={"/roles/{id}"})
    public ResponseEntity<?> getRolById(@PathVariable Integer id) {
        Optional perfilOpt = this.perfilService.getPerfilById(id);
        if (perfilOpt.isEmpty()) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body((Object)"Rol no encontrado");
        }
        Perfil perfil = (Perfil)perfilOpt.get();
        if (!perfil.getNombrePerfil().startsWith("SUPERADMIN_")) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.FORBIDDEN).body((Object)"Este no es un rol de SuperAdmin");
        }
        return ResponseEntity.ok((Object)perfil);
    }

    @PostMapping(value={"/roles"})
    public ResponseEntity<?> createRol(@RequestBody Perfil perfil) {
        if (perfil.getNombrePerfil() == null || perfil.getNombrePerfil().isEmpty()) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)"El nombre del rol es requerido");
        }
        if (!perfil.getNombrePerfil().startsWith("SUPERADMIN_")) {
            perfil.setNombrePerfil("SUPERADMIN_" + perfil.getNombrePerfil());
        }
        perfil.setEstado(Integer.valueOf(1));
        Perfil saved = this.perfilService.savePerfil(perfil);
        if (perfil.getNombrePerfil().contains("ADMIN") || perfil.getNombrePerfil().contains("Administrador")) {
            try {
                List todosModulos = this.moduloService.getAllModulos();
                for (Modulo modulo : todosModulos) {
                    if (this.accesoService.existeAcceso(modulo.getIdModulo(), saved.getIdPerfil())) continue;
                    Acceso nuevoAcceso = new Acceso();
                    nuevoAcceso.setIdPerfil(saved.getIdPerfil());
                    nuevoAcceso.setIdModulo(modulo.getIdModulo());
                    nuevoAcceso.setEstado(Integer.valueOf(1));
                    this.accesoService.saveAcceso(nuevoAcceso);
                }
                System.out.println("\u2705 Todos los m\u00f3dulos asignados autom\u00e1ticamente al rol administrativo: " + perfil.getNombrePerfil());
            }
            catch (Exception e) {
                System.err.println("\u26a0\ufe0f Error al asignar m\u00f3dulos autom\u00e1ticamente: " + e.getMessage());
                e.printStackTrace();
            }
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)saved);
    }

    @PutMapping(value={"/roles/{id}"})
    public ResponseEntity<?> updateRol(@PathVariable Integer id, @RequestBody Perfil perfil) {
        Optional existingOpt = this.perfilService.getPerfilById(id);
        if (existingOpt.isEmpty()) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body((Object)"Rol no encontrado");
        }
        Perfil existing = (Perfil)existingOpt.get();
        if (!existing.getNombrePerfil().startsWith("SUPERADMIN_")) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.FORBIDDEN).body((Object)"No puedes modificar roles que no son de SuperAdmin");
        }
        if (!perfil.getNombrePerfil().startsWith("SUPERADMIN_")) {
            perfil.setNombrePerfil("SUPERADMIN_" + perfil.getNombrePerfil());
        }
        perfil.setIdPerfil(id);
        Perfil updated = this.perfilService.savePerfil(perfil);
        return ResponseEntity.ok((Object)updated);
    }

    @DeleteMapping(value={"/roles/{id}"})
    public ResponseEntity<?> deleteRol(@PathVariable Integer id) {
        Optional perfilOpt = this.perfilService.getPerfilById(id);
        if (perfilOpt.isEmpty()) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body((Object)"Rol no encontrado");
        }
        Perfil perfil = (Perfil)perfilOpt.get();
        if (!perfil.getNombrePerfil().startsWith("SUPERADMIN_")) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.FORBIDDEN).body((Object)"No puedes eliminar roles que no son de SuperAdmin");
        }
        this.perfilService.deletePerfil(id);
        return ResponseEntity.ok((Object)"Rol eliminado correctamente");
    }

    @GetMapping(value={"/permisos"})
    public ResponseEntity<List<Modulo>> getAllPermisos() {
        return ResponseEntity.ok((Object)this.moduloService.getAllModulos());
    }

    @GetMapping(value={"/permisos/{id}"})
    public ResponseEntity<?> getPermisoById(@PathVariable Integer id) {
        return this.moduloService.getModuloById(id).map(ResponseEntity::ok).orElseGet(() -> ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body(null));
    }

    @PostMapping(value={"/permisos"})
    public ResponseEntity<Modulo> createPermiso(@RequestBody Modulo modulo) {
        modulo.setEstado(Integer.valueOf(1));
        Modulo saved = this.moduloService.saveModulo(modulo);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)saved);
    }

    @PutMapping(value={"/permisos/{id}"})
    public ResponseEntity<?> updatePermiso(@PathVariable Integer id, @RequestBody Modulo modulo) {
        if (this.moduloService.getModuloById(id).isEmpty()) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body((Object)"Permiso no encontrado");
        }
        modulo.setIdModulo(id);
        Modulo updated = this.moduloService.saveModulo(modulo);
        return ResponseEntity.ok((Object)updated);
    }

    @DeleteMapping(value={"/permisos/{id}"})
    public ResponseEntity<?> deletePermiso(@PathVariable Integer id) {
        if (this.moduloService.getModuloById(id).isEmpty()) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body((Object)"Permiso no encontrado");
        }
        this.moduloService.deleteModulo(id);
        return ResponseEntity.ok((Object)"Permiso eliminado correctamente");
    }

    @GetMapping(value={"/roles/{idRol}/permisos"})
    public ResponseEntity<?> getPermisosByRol(@PathVariable Integer idRol) {
        List accesos = this.accesoService.getAllAccesos().stream().filter(a -> a.getIdPerfil().equals(idRol)).collect(Collectors.toList());
        List idsModulos = accesos.stream().map(Acceso::getIdModulo).collect(Collectors.toList());
        return ResponseEntity.ok(idsModulos);
    }

    @PostMapping(value={"/roles/{idRol}/permisos"})
    public ResponseEntity<?> asignarPermisos(@PathVariable Integer idRol, @RequestBody List<Integer> idsModulos) {
        System.out.println("Asignando permisos al rol " + String.valueOf(idRol) + ": " + String.valueOf(idsModulos));
        Optional perfilOpt = this.perfilService.getPerfilById(idRol);
        if (perfilOpt.isEmpty()) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body((Object)"Rol no encontrado");
        }
        List accesosAnteriores = this.accesoService.getAllAccesos().stream().filter(a -> a.getIdPerfil().equals(idRol)).collect(Collectors.toList());
        for (Acceso acceso : accesosAnteriores) {
            this.accesoService.deleteAcceso(acceso.getIdAcceso());
        }
        for (Integer idModulo : idsModulos) {
            Acceso nuevoAcceso = new Acceso();
            nuevoAcceso.setIdPerfil(idRol);
            nuevoAcceso.setIdModulo(idModulo);
            nuevoAcceso.setEstado(Integer.valueOf(1));
            this.accesoService.saveAcceso(nuevoAcceso);
        }
        return ResponseEntity.ok(Map.of("mensaje", "Permisos asignados correctamente", "totalPermisos", idsModulos.size()));
    }

    @GetMapping(value={"/restaurantes"})
    public ResponseEntity<List<RestauranteDTO>> getAllRestaurantes() {
        return ResponseEntity.ok((Object)this.restauranteService.obtenerTodos());
    }

    @GetMapping(value={"/restaurantes/{id}"})
    public ResponseEntity<?> getRestauranteById(@PathVariable Integer id) {
        return this.restauranteService.buscarId(id).map(ResponseEntity::ok).orElseGet(() -> ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body(null));
    }

    @PostMapping(value={"/restaurantes"})
    public ResponseEntity<?> createRestaurante(@RequestBody Restaurante restaurante) {
        try {
            if (this.restauranteService.existsByRuc(restaurante.getRuc())) {
                return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)("{\"error\": \"El RUC " + restaurante.getRuc() + " ya est\u00e1 registrado en el sistema.\"}"));
            }
            restaurante.setEstado(Integer.valueOf(1));
            Restaurante saved = this.restauranteService.guardar(restaurante);
            Sucursales sucursalPrincipal = new Sucursales();
            sucursalPrincipal.setIdRestaurante(saved.getIdRestaurante());
            sucursalPrincipal.setNombre("Sucursal Principal");
            String direccion = saved.getDireccion();
            if (direccion == null || direccion.trim().isEmpty()) {
                direccion = "Direcci\u00f3n Pendiente de Actualizar";
            }
            sucursalPrincipal.setDireccion(direccion);
            sucursalPrincipal.setEstado(Integer.valueOf(1));
            this.sucursalesService.guardar(sucursalPrincipal);
            try {
                Authentication auth = SecurityContextHolder.getContext().getAuthentication();
                String emailSuperAdmin = auth.getName();
                Optional adminOpt = this.superAdminService.getSuperAdminByEmail(emailSuperAdmin);
                if (adminOpt.isPresent()) {
                    this.reporteService.registrarAccion((SuperAdmin)adminOpt.get(), "CREAR_RESTAURANTE", "Cre\u00f3 restaurante: " + saved.getNombre() + " (RUC: " + saved.getRuc() + ")", "IP_PENDIENTE");
                }
            }
            catch (Exception ex) {
                System.err.println("Error al registrar reporte: " + ex.getMessage());
            }
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)saved);
        }
        catch (Exception e) {
            System.err.println("\u274c Error al crear restaurante: " + e.getMessage());
            e.printStackTrace();
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("{\"error\": \"Error interno: " + e.getMessage() + "\"}"));
        }
    }

    @PutMapping(value={"/restaurantes/{id}"})
    public ResponseEntity<?> updateRestaurante(@PathVariable Integer id, @RequestBody Restaurante restauranteData) {
        Optional optionalRestaurante = this.restauranteService.buscarId(id);
        if (optionalRestaurante.isEmpty()) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body((Object)"Restaurante no encontrado");
        }
        Restaurante existing = (Restaurante)optionalRestaurante.get();
        if (restauranteData.getNombre() != null) {
            existing.setNombre(restauranteData.getNombre());
        }
        if (restauranteData.getRuc() != null) {
            existing.setRuc(restauranteData.getRuc());
        }
        if (restauranteData.getDireccion() != null) {
            existing.setDireccion(restauranteData.getDireccion());
        }
        if (restauranteData.getLogoUrl() != null) {
            existing.setLogoUrl(restauranteData.getLogoUrl());
        }
        if (restauranteData.getSimboloMoneda() != null) {
            existing.setSimboloMoneda(restauranteData.getSimboloMoneda());
        }
        if (restauranteData.getTasaIgv() != null) {
            existing.setTasaIgv(restauranteData.getTasaIgv());
        }
        if (restauranteData.getEmailContacto() != null) {
            existing.setEmailContacto(restauranteData.getEmailContacto());
        }
        if (restauranteData.getEstado() != null) {
            existing.setEstado(restauranteData.getEstado());
        }
        if (restauranteData.getFechaVencimiento() != null) {
            existing.setFechaVencimiento(restauranteData.getFechaVencimiento());
        }
        if (existing.getFechaVencimiento() == null) {
            existing.setFechaVencimiento(LocalDateTime.now().plusMonths(1L));
        }
        if (existing.getFechaCreacion() == null) {
            existing.setFechaCreacion(LocalDateTime.now());
        }
        Restaurante updated = this.restauranteService.guardar(existing);
        try {
            Authentication auth = SecurityContextHolder.getContext().getAuthentication();
            String emailSuperAdmin = auth.getName();
            Optional adminOpt = this.superAdminService.getSuperAdminByEmail(emailSuperAdmin);
            if (adminOpt.isPresent()) {
                this.reporteService.registrarAccion((SuperAdmin)adminOpt.get(), "ACTUALIZAR_RESTAURANTE", "Actualiz\u00f3 restaurante ID " + String.valueOf(id) + ": " + updated.getNombre(), "IP_PENDIENTE");
            }
        }
        catch (Exception ex) {
            System.err.println("Error al registrar reporte: " + ex.getMessage());
        }
        return ResponseEntity.ok((Object)updated);
    }

    @DeleteMapping(value={"/restaurantes/{id}"})
    public ResponseEntity<?> deleteRestaurante(@PathVariable Integer id) {
        if (this.restauranteService.buscarId(id).isEmpty()) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body((Object)"Restaurante no encontrado");
        }
        this.restauranteService.eliminar(id);
        try {
            Authentication auth = SecurityContextHolder.getContext().getAuthentication();
            String emailSuperAdmin = auth.getName();
            Optional adminOpt = this.superAdminService.getSuperAdminByEmail(emailSuperAdmin);
            if (adminOpt.isPresent()) {
                this.reporteService.registrarAccion((SuperAdmin)adminOpt.get(), "ELIMINAR_RESTAURANTE", "Elimin\u00f3 restaurante ID: " + String.valueOf(id), "IP_PENDIENTE");
            }
        }
        catch (Exception ex) {
            System.err.println("Error al registrar reporte: " + ex.getMessage());
        }
        return ResponseEntity.ok((Object)"Restaurante eliminado correctamente");
    }

    @PostMapping(value={"/usuarios"})
    public ResponseEntity<?> createUsuario(@RequestBody Map<String, Object> request) {
        try {
            String nombreUsuario = (String)request.get("nombreUsuario");
            String apellidos = (String)request.get("apellidos");
            String dniUsuario = (String)request.get("dniUsuario");
            String telefono = (String)request.get("telefono");
            String nombreUsuarioLogin = (String)request.get("nombreUsuarioLogin");
            String contrasena = (String)request.get("contrasena");
            Object rolIdObj = request.get("rolId");
            Integer rolId = null;
            if (rolIdObj instanceof Number) {
                rolId = ((Number)rolIdObj).intValue();
            } else if (rolIdObj instanceof String) {
                try {
                    rolId = Integer.parseInt((String)rolIdObj);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            Object idSucursalObj = request.get("idSucursal");
            Integer idSucursal = null;
            if (idSucursalObj instanceof Number) {
                idSucursal = ((Number)idSucursalObj).intValue();
            } else if (idSucursalObj instanceof String) {
                try {
                    idSucursal = Integer.parseInt((String)idSucursalObj);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (nombreUsuario == null || apellidos == null || dniUsuario == null || nombreUsuarioLogin == null || contrasena == null || rolId == null || idSucursal == null) {
                return ResponseEntity.badRequest().body((Object)"{\"error\": \"Faltan datos obligatorios\"}");
            }
            if (this.usuarioService.getUsuarioByLogin(nombreUsuarioLogin).isPresent()) {
                return ResponseEntity.badRequest().body((Object)"{\"error\": \"El nombre de usuario ya existe\"}");
            }
            if (idSucursal != null) {
                List sucursales = this.sucursalesService.buscarTodosPorRestaurante(idSucursal);
                if (sucursales != null && !sucursales.isEmpty()) {
                    idSucursal = ((Sucursales)sucursales.get(0)).getIdSucursal();
                } else {
                    System.out.println("\u26a0\ufe0f No se encontraron sucursales para el Restaurante ID: " + String.valueOf(idSucursal));
                }
            }
            Usuarios newUser = new Usuarios();
            newUser.setNombreUsuario(nombreUsuario);
            newUser.setApellidos(apellidos);
            newUser.setDniUsuario(dniUsuario);
            newUser.setTelefono(telefono);
            newUser.setNombreUsuarioLogin(nombreUsuarioLogin);
            newUser.setRolId(rolId);
            newUser.setIdSucursal(idSucursal);
            newUser.setEstado(Integer.valueOf(1));
            newUser.setFechaCreacion(LocalDateTime.now());
            String hashedPassword = this.hashPasswordHex(contrasena);
            newUser.setContrasena(hashedPassword);
            Usuarios savedUser = this.usuarioService.saveUsuarios(newUser);
            Authentication auth = SecurityContextHolder.getContext().getAuthentication();
            this.superAdminService.getSuperAdminByEmail(auth.getName()).ifPresent(admin -> this.reporteService.registrarAccion(admin, "CREAR_USUARIO", "Cre\u00f3 Usuario: " + savedUser.getNombreUsuarioLogin(), "IP_PENDIENTE"));
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)savedUser);
        }
        catch (Exception e) {
            e.printStackTrace();
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("{\"error\": \"Error al crear usuario: " + e.getMessage() + "\"}"));
        }
    }

    @PostMapping(value={"/crear-administrador"})
    public ResponseEntity<?> crearAdministrador(@RequestBody Map<String, Object> request) {
        try {
            Authentication auth = SecurityContextHolder.getContext().getAuthentication();
            boolean isMaster = auth.getAuthorities().stream().anyMatch(a -> a.getAuthority().equals("ROLE_MASTER"));
            if (!isMaster) {
                return ResponseEntity.status((HttpStatusCode)HttpStatus.FORBIDDEN).body((Object)"Acceso denegado: Solo el MASTER puede crear administradores");
            }
            String nombreUsuario = (String)request.get("nombreUsuario");
            String apellidos = (String)request.get("apellidos");
            String dniUsuario = (String)request.get("dniUsuario");
            String telefono = (String)request.get("telefono");
            String nombreUsuarioLogin = (String)request.get("nombreUsuarioLogin");
            String contrasena = (String)request.get("contrasena");
            Object rolIdObj = request.get("rolId");
            Integer rolId = null;
            if (rolIdObj instanceof Number) {
                rolId = ((Number)rolIdObj).intValue();
            } else if (rolIdObj instanceof String) {
                try {
                    rolId = Integer.parseInt((String)rolIdObj);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            Object idSucursalObj = request.get("idSucursal");
            Integer idSucursal = null;
            if (idSucursalObj instanceof Number) {
                idSucursal = ((Number)idSucursalObj).intValue();
            } else if (idSucursalObj instanceof String) {
                try {
                    idSucursal = Integer.parseInt((String)idSucursalObj);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (nombreUsuario == null || apellidos == null || dniUsuario == null || nombreUsuarioLogin == null || contrasena == null || rolId == null || idSucursal == null) {
                return ResponseEntity.badRequest().body((Object)"{\"error\": \"Faltan datos obligatorios\"}");
            }
            if (this.usuarioService.getUsuarioByLogin(nombreUsuarioLogin).isPresent()) {
                return ResponseEntity.badRequest().body((Object)"{\"error\": \"El nombre de usuario ya existe\"}");
            }
            if (idSucursal != null) {
                List sucursales = this.sucursalesService.buscarTodosPorRestaurante(idSucursal);
                if (sucursales != null && !sucursales.isEmpty()) {
                    idSucursal = ((Sucursales)sucursales.get(0)).getIdSucursal();
                } else {
                    System.out.println("\u26a0\ufe0f No se encontraron sucursales para el Restaurante ID: " + String.valueOf(idSucursal));
                }
            }
            Usuarios newUser = new Usuarios();
            newUser.setNombreUsuario(nombreUsuario);
            newUser.setApellidos(apellidos);
            newUser.setDniUsuario(dniUsuario);
            newUser.setTelefono(telefono);
            newUser.setNombreUsuarioLogin(nombreUsuarioLogin);
            newUser.setRolId(rolId);
            newUser.setIdSucursal(idSucursal);
            newUser.setEstado(Integer.valueOf(1));
            newUser.setFechaCreacion(LocalDateTime.now());
            String hashedPassword = this.hashPasswordHex(contrasena);
            newUser.setContrasena(hashedPassword);
            Usuarios savedUser = this.usuarioService.saveUsuarios(newUser);
            Integer finalRolId = rolId;
            try {
                List todosModulos = this.moduloService.getAllModulos();
                List accesosAnteriores = this.accesoService.getAllAccesos().stream().filter(a -> a.getIdPerfil().equals(finalRolId)).collect(Collectors.toList());
                for (Acceso acceso : accesosAnteriores) {
                    this.accesoService.deleteAcceso(acceso.getIdAcceso());
                }
                for (Modulo modulo : todosModulos) {
                    Acceso nuevoAcceso = new Acceso();
                    nuevoAcceso.setIdPerfil(finalRolId);
                    nuevoAcceso.setIdModulo(modulo.getIdModulo());
                    nuevoAcceso.setEstado(Integer.valueOf(1));
                    this.accesoService.saveAcceso(nuevoAcceso);
                }
                System.out.println("\u2705 Administrador creado con \u00e9xito: " + nombreUsuarioLogin);
                System.out.println("\u2705 Se asignaron " + todosModulos.size() + " m\u00f3dulos/accesos autom\u00e1ticamente");
            }
            catch (Exception e) {
                System.err.println("\u26a0\ufe0f Error al asignar accesos: " + e.getMessage());
                e.printStackTrace();
            }
            Authentication authLog = SecurityContextHolder.getContext().getAuthentication();
            this.superAdminService.getSuperAdminByEmail(authLog.getName()).ifPresent(admin -> this.reporteService.registrarAccion(admin, "CREAR_ADMINISTRADOR", "Cre\u00f3 Admin (Usuario): " + savedUser.getNombreUsuarioLogin(), "IP_PENDIENTE"));
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)savedUser);
        }
        catch (Exception e) {
            e.printStackTrace();
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("{\"error\": \"Error al crear administrador: " + e.getMessage() + "\"}"));
        }
    }

    @GetMapping(value={"/usuarios"})
    public ResponseEntity<List<Usuarios>> getAllUsuarios() {
        return ResponseEntity.ok((Object)this.usuarioService.getAllUsuarios());
    }

    @GetMapping(value={"/usuarios/{id}"})
    public ResponseEntity<?> getUsuarioById(@PathVariable Integer id) {
        return this.usuarioService.getUsuarioById(id).map(ResponseEntity::ok).orElse(ResponseEntity.notFound().build());
    }

    @PutMapping(value={"/usuarios/{id}"})
    public ResponseEntity<?> updateUsuario(@PathVariable Integer id, @RequestBody Map<String, Object> request) {
        try {
            String nuevaContrasena;
            Object idSucursalObj;
            Optional usuarioOpt = this.usuarioService.getUsuarioById(id);
            if (usuarioOpt.isEmpty()) {
                return ResponseEntity.notFound().build();
            }
            Usuarios usuario = (Usuarios)usuarioOpt.get();
            if (request.get("nombreUsuario") != null) {
                usuario.setNombreUsuario((String)request.get("nombreUsuario"));
            }
            if (request.get("apellidos") != null) {
                usuario.setApellidos((String)request.get("apellidos"));
            }
            if (request.get("nombreUsuarioLogin") != null) {
                usuario.setNombreUsuarioLogin((String)request.get("nombreUsuarioLogin"));
            }
            if (request.get("dniUsuario") != null) {
                usuario.setDniUsuario((String)request.get("dniUsuario"));
            }
            if (request.get("telefono") != null) {
                usuario.setTelefono((String)request.get("telefono"));
            }
            if (request.get("idSucursal") != null && (idSucursalObj = request.get("idSucursal")) instanceof Number) {
                usuario.setIdSucursal(Integer.valueOf(((Number)idSucursalObj).intValue()));
            }
            if (request.get("contrasenaUsuario") != null && !(nuevaContrasena = (String)request.get("contrasenaUsuario")).isEmpty()) {
                String hashedPassword = this.hashPasswordHex(nuevaContrasena);
                usuario.setContrasena(hashedPassword);
            }
            Usuarios updated = this.usuarioService.saveUsuarios(usuario);
            Authentication authCtx = SecurityContextHolder.getContext().getAuthentication();
            this.superAdminService.getSuperAdminByEmail(authCtx.getName()).ifPresent(admin -> this.reporteService.registrarAccion(admin, "ACTUALIZAR_USUARIO", "Actualiz\u00f3 Usuario: " + updated.getNombreUsuarioLogin(), "IP_PENDIENTE"));
            return ResponseEntity.ok((Object)updated);
        }
        catch (Exception e) {
            e.printStackTrace();
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("{\"error\": \"Error al actualizar usuario: " + e.getMessage() + "\"}"));
        }
    }

    @DeleteMapping(value={"/usuarios/{id}"})
    public ResponseEntity<?> deleteUsuario(@PathVariable Integer id) {
        try {
            if (this.usuarioService.getUsuarioById(id).isEmpty()) {
                return ResponseEntity.notFound().build();
            }
            this.usuarioService.deleteUsuario(id);
            Authentication auth = SecurityContextHolder.getContext().getAuthentication();
            this.superAdminService.getSuperAdminByEmail(auth.getName()).ifPresent(admin -> this.reporteService.registrarAccion(admin, "ELIMINAR_USUARIO", "Elimin\u00f3 Usuario ID: " + String.valueOf(id), "IP_PENDIENTE"));
            return ResponseEntity.ok().build();
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("{\"error\": \"Error al eliminar usuario: " + e.getMessage() + "\"}"));
        }
    }

    @GetMapping(value={"/bitacora"})
    public ResponseEntity<List<BitacoraAccion>> getBitacora() {
        return ResponseEntity.ok((Object)this.bitacoraService.obtenerTodos());
    }

    @GetMapping(value={"/bitacora/usuario/{idUsuario}"})
    public ResponseEntity<List<BitacoraAccion>> getBitacoraPorUsuario(@PathVariable Integer idUsuario) {
        return ResponseEntity.ok((Object)this.bitacoraService.obtenerPorUsuario(idUsuario));
    }

    @GetMapping(value={"/bitacora/tabla/{tabla}"})
    public ResponseEntity<List<BitacoraAccion>> getBitacoraPorTabla(@PathVariable String tabla) {
        return ResponseEntity.ok((Object)this.bitacoraService.obtenerPorTabla(tabla));
    }

    @GetMapping(value={"/bitacora/estadisticas"})
    public ResponseEntity<?> getEstadisticasBitacora() {
        return ResponseEntity.ok((Object)this.bitacoraService.estadisticasPorAccion());
    }

    @PatchMapping(value={"/super-admins/{id}/estado"})
    public ResponseEntity<?> toggleEstadoSuperAdmin(@PathVariable Integer id, @RequestBody Map<String, Integer> body) {
        try {
            SuperAdmin sa = this.superAdminService.getSuperAdminById(id).orElse(null);
            if (sa == null) {
                return ResponseEntity.notFound().build();
            }
            sa.setEstado(body.get("estado"));
            SuperAdmin updated = this.superAdminService.createSuperAdmin(sa);
            return ResponseEntity.ok((Object)updated);
        }
        catch (Exception e) {
            return ResponseEntity.badRequest().body((Object)("Error: " + e.getMessage()));
        }
    }

    @PatchMapping(value={"/usuarios/{id}/estado"})
    public ResponseEntity<?> toggleEstadoUsuario(@PathVariable Integer id, @RequestBody Map<String, Integer> body) {
        try {
            Usuarios usuario = this.usuarioService.getUsuarioById(id).orElse(null);
            if (usuario == null) {
                return ResponseEntity.notFound().build();
            }
            usuario.setEstado(body.get("estado"));
            Usuarios updated = this.usuarioService.saveUsuarios(usuario);
            return ResponseEntity.ok((Object)updated);
        }
        catch (Exception e) {
            return ResponseEntity.badRequest().body((Object)("Error: " + e.getMessage()));
        }
    }
}

