/*
 * Decompiled with CFR 0.152.
 */
package web.Regional_Api.controller;

import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import web.Regional_Api.entity.Usuarios;
import web.Regional_Api.security.JwtUtil;
import web.Regional_Api.service.EmailService;
import web.Regional_Api.service.IPerfilService;
import web.Regional_Api.service.IUsuarioService;

@RestController
@RequestMapping(value={"/restful"})
public class UsuarioController {
    @Autowired
    private IUsuarioService usuarioService;
    @Autowired
    private JwtUtil jwtUtil;
    @Autowired
    private BCryptPasswordEncoder passwordEncoder;
    @Autowired
    private IPerfilService perfilService;
    @Autowired
    private EmailService emailService;
    private static volatile /* synthetic */ int[] $SWITCH_TABLE$org$apache$poi$ss$usermodel$CellType;

    @GetMapping(value={"/usuarios"})
    public List<Usuarios> listar() {
        return this.usuarioService.getAllUsuarios();
    }

    @GetMapping(value={"/usuarios/sucursal/{idSucursal}"})
    public ResponseEntity<?> obtenerPorSucursal(@PathVariable Integer idSucursal) {
        try {
            List usuarios = this.usuarioService.getUsuariosBySucursal(idSucursal);
            return ResponseEntity.ok((Object)usuarios);
        }
        catch (Exception ex) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)"Error al obtener usuarios por sucursal");
        }
    }

    @GetMapping(value={"/usuarios/{id}"})
    public ResponseEntity<?> obtenerPorId(@PathVariable Integer id) {
        Optional opt = this.usuarioService.getUsuarioById(id);
        return opt.map(ResponseEntity::ok).orElseGet(() -> ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body((Object)"Usuario no encontrado"));
    }

    @PostMapping(value={"/usuarios"})
    public ResponseEntity<?> crear(@RequestBody Usuarios usuario) {
        try {
            Usuarios creado = this.usuarioService.registrarUsuario(usuario);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)creado);
        }
        catch (RuntimeException ex) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)ex.getMessage());
        }
    }

    @PutMapping(value={"/usuarios/{id}"})
    public ResponseEntity<?> actualizar(@PathVariable Integer id, @RequestBody Usuarios usuario) {
        Optional actualizado = this.usuarioService.updateUsuario(id, usuario);
        return actualizado.map(ResponseEntity::ok).orElseGet(() -> ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body((Object)"Usuario no encontrado"));
    }

    @DeleteMapping(value={"/usuarios/{id}"})
    public ResponseEntity<?> eliminar(@PathVariable Integer id) {
        try {
            this.usuarioService.deleteUsuario(id);
            return ResponseEntity.ok((Object)"Usuario eliminado");
        }
        catch (RuntimeException ex) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body((Object)ex.getMessage());
        }
    }

    @PostMapping(value={"/usuarios/login"})
    public ResponseEntity<?> login(@RequestBody Map<String, String> loginRequest) {
        String username = loginRequest.get("nombreUsuarioLogin");
        String plainPassword = loginRequest.get("contrasena");
        System.out.println("Intento de login para: " + username);
        System.out.println("Contrase\u00f1a recibida (texto plano): " + plainPassword);
        Optional usuarioOpt = this.usuarioService.getUsuarioByLogin(username);
        if (usuarioOpt.isPresent()) {
            Usuarios usuario = (Usuarios)usuarioOpt.get();
            System.out.println("Usuario encontrado en BD: " + usuario.getNombreUsuarioLogin());
            String hashedPassword = this.hashPassword(plainPassword);
            System.out.println("Hash calculado: " + hashedPassword);
            System.out.println("Hash en BD: " + usuario.getContrasena());
            if (hashedPassword.equals(usuario.getContrasena())) {
                System.out.println("\u00a1Contrase\u00f1a correcta!");
                String token = this.jwtUtil.generarToken(usuario.getNombreUsuarioLogin());
                String nombrePerfil = "Sin perfil";
                if (usuario.getRolId() != null) {
                    nombrePerfil = this.perfilService.getPerfilById(usuario.getRolId()).map(perfil -> perfil.getNombrePerfil()).orElse("Sin perfil");
                }
                HashMap<String, Object> response = new HashMap<String, Object>();
                response.put("token", token);
                response.put("idUsuario", usuario.getIdUsuario());
                response.put("nombreUsuario", usuario.getNombreUsuario());
                response.put("apellidos", usuario.getApellidos());
                response.put("nombreUsuarioLogin", usuario.getNombreUsuarioLogin());
                response.put("idPerfil", usuario.getRolId());
                response.put("nombrePerfil", nombrePerfil);
                response.put("idSucursal", usuario.getIdSucursal());
                if (usuario.getRolId() != null && usuario.getRolId() >= 5) {
                    try {
                        String emailDestinatario = "anllyriva14@gmail.com";
                        this.emailService.enviarTokenSuperAdmin(emailDestinatario, token, usuario.getNombreUsuario());
                        response.put("tokenEnviadoPorEmail", true);
                        response.put("emailDestinatario", emailDestinatario);
                        System.out.println("\u2705 Token enviado por email a: " + emailDestinatario);
                    }
                    catch (Exception e) {
                        System.err.println("\u274c Error al enviar email: " + e.getMessage());
                        response.put("tokenEnviadoPorEmail", false);
                        response.put("errorEmail", "No se pudo enviar el email, pero puedes usar el token directamente");
                    }
                } else {
                    response.put("tokenEnviadoPorEmail", false);
                }
                return ResponseEntity.ok(response);
            }
            System.out.println("\u00a1Contrase\u00f1a incorrecta!");
        } else {
            System.out.println("Usuario no encontrado en BD");
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).body((Object)"Credenciales inv\u00e1lidas");
    }

    @PostMapping(value={"/usuarios/import"})
    public ResponseEntity<?> importarUsuarios(@RequestParam(value="file") MultipartFile file) {
        try {
            String filename = file.getOriginalFilename();
            if (filename == null || !filename.endsWith(".xlsx") && !filename.endsWith(".xls")) {
                return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)"El archivo debe ser formato Excel (.xlsx o .xls)");
            }
            Object workbook = filename.endsWith(".xlsx") ? new XSSFWorkbook(file.getInputStream()) : new HSSFWorkbook(file.getInputStream());
            Sheet sheet = workbook.getSheetAt(0);
            ArrayList resultados = new ArrayList();
            int exitosos = 0;
            int fallidos = 0;
            HashMap<String, Integer> contadorNombres = new HashMap<String, Integer>();
            int i = 1;
            while (i <= sheet.getLastRowNum()) {
                Row row = sheet.getRow(i);
                if (row != null) {
                    try {
                        String idStr = this.getCellValueAsString(row.getCell(0));
                        String nombreCompleto = this.getCellValueAsString(row.getCell(1));
                        String email = this.getCellValueAsString(row.getCell(2));
                        String rolTexto = this.getCellValueAsString(row.getCell(3));
                        String estadoTexto = this.getCellValueAsString(row.getCell(4));
                        String telefono = this.getCellValueAsString(row.getCell(5));
                        if (nombreCompleto == null || nombreCompleto.trim().isEmpty()) {
                            ++fallidos;
                            HashMap<String, Object> error = new HashMap<String, Object>();
                            error.put("fila", i + 1);
                            error.put("error", "Nombre completo es requerido");
                            resultados.add(error);
                        } else {
                            String[] partesNombre = nombreCompleto.trim().split("\\s+", 2);
                            String nombreUsuario = partesNombre[0];
                            String apellidos = partesNombre.length > 1 ? partesNombre[1] : "";
                            Integer rolId = this.mapearRolTextoAId(rolTexto);
                            String baseLogin = nombreUsuario.trim().replaceAll("\\s+", "");
                            int contador = contadorNombres.getOrDefault(baseLogin, 0) + 1;
                            contadorNombres.put(baseLogin, contador);
                            String nombreUsuarioLogin = baseLogin + contador;
                            while (this.usuarioService.getUsuarioByLogin(nombreUsuarioLogin).isPresent()) {
                                contadorNombres.put(baseLogin, ++contador);
                                nombreUsuarioLogin = baseLogin + contador;
                            }
                            String contrasenaTemporal = "Temporal123";
                            String contrasenaHash = this.hashPassword(contrasenaTemporal);
                            Usuarios nuevoUsuario = new Usuarios();
                            nuevoUsuario.setNombreUsuario(nombreUsuario.trim());
                            nuevoUsuario.setApellidos(apellidos.trim());
                            nuevoUsuario.setNombreUsuarioLogin(nombreUsuarioLogin);
                            nuevoUsuario.setContrasena(contrasenaHash);
                            nuevoUsuario.setRolId(rolId);
                            nuevoUsuario.setIdSucursal(Integer.valueOf(0));
                            nuevoUsuario.setEstado(Integer.valueOf(1));
                            this.usuarioService.registrarUsuario(nuevoUsuario);
                            ++exitosos;
                            HashMap<String, Object> exito = new HashMap<String, Object>();
                            exito.put("fila", i + 1);
                            exito.put("nombre", nombreCompleto);
                            exito.put("usuario", nombreUsuarioLogin);
                            exito.put("contrasena", contrasenaTemporal);
                            exito.put("email", email != null ? email : "N/A");
                            resultados.add(exito);
                        }
                    }
                    catch (Exception e) {
                        ++fallidos;
                        HashMap<String, Object> error = new HashMap<String, Object>();
                        error.put("fila", i + 1);
                        error.put("error", e.getMessage());
                        resultados.add(error);
                    }
                }
                ++i;
            }
            workbook.close();
            HashMap<String, Object> respuesta = new HashMap<String, Object>();
            respuesta.put("exitosos", exitosos);
            respuesta.put("fallidos", fallidos);
            respuesta.put("detalles", resultados);
            respuesta.put("mensaje", "Importaci\u00f3n completada: " + exitosos + " usuarios creados, " + fallidos + " errores");
            return ResponseEntity.ok(respuesta);
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("Error al procesar el archivo: " + e.getMessage()));
        }
    }

    /*
     * Exception decompiling
     */
    private String getCellValueAsString(Cell cell) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.entities.ClassFileField.getField()" because "fieldvar" is null
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewriteEclipse(SwitchEnumRewriter.java:239)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewrite(SwitchEnumRewriter.java:153)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.rewrite(SwitchEnumRewriter.java:86)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:882)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private Integer getCellValueAsInteger(Cell cell) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.entities.ClassFileField.getField()" because "fieldvar" is null
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewriteEclipse(SwitchEnumRewriter.java:239)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewrite(SwitchEnumRewriter.java:153)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.rewrite(SwitchEnumRewriter.java:86)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:882)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Integer mapearRolTextoAId(String rolTexto) {
        String rolLower;
        if (rolTexto == null) {
            return null;
        }
        switch (rolLower = rolTexto.trim().toLowerCase()) {
            case "administrador": 
            case "admin": {
                return 5;
            }
            case "gerente": 
            case "manager": {
                return 3;
            }
            case "usuario": 
            case "user": {
                return 2;
            }
        }
        return null;
    }

    private String hashPassword(String plainPassword) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(plainPassword.getBytes());
            byte[] digest = md.digest();
            BigInteger result = new BigInteger(1, digest);
            Object hash = result.toString(16).toUpperCase();
            while (((String)hash).length() < 64) {
                hash = "0" + (String)hash;
            }
            return hash;
        }
        catch (Exception e) {
            throw new RuntimeException("Error al encriptar la contrase\u00f1a", e);
        }
    }

    static /* synthetic */ int[] $SWITCH_TABLE$org$apache$poi$ss$usermodel$CellType() {
        if ($SWITCH_TABLE$org$apache$poi$ss$usermodel$CellType != null) {
            return $SWITCH_TABLE$org$apache$poi$ss$usermodel$CellType;
        }
        int[] nArray = new int[CellType.values().length];
        try {
            nArray[CellType.BLANK.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[CellType.BOOLEAN.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[CellType.ERROR.ordinal()] = 7;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[CellType.FORMULA.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[CellType.NUMERIC.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[CellType.STRING.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[CellType._NONE.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$org$apache$poi$ss$usermodel$CellType = nArray;
        return nArray;
    }
}

