/*
 * Decompiled with CFR 0.152.
 */
package web.Regional_Api.controller;

import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import web.Regional_Api.entity.Ventas;
import web.Regional_Api.service.IVentasService;

@RestController
@RequestMapping(value={"/restful"})
public class VentasController {
    @Autowired
    private IVentasService serviceVentas;

    @GetMapping(value={"/ventas/todos"})
    public List<Ventas> buscarTodas() {
        return this.serviceVentas.buscarTodas();
    }

    @GetMapping(value={"/ventas/sesion/{idSesion}"})
    public List<Ventas> buscarTodasPorSesion(@PathVariable(value="idSesion") Integer idSesion) {
        return this.serviceVentas.buscarTodasPorSesion(idSesion);
    }

    @GetMapping(value={"/ventas/{id}"})
    public Optional<Ventas> buscarId(@PathVariable(value="id") Integer idVenta) {
        return this.serviceVentas.buscarId(idVenta);
    }

    @PostMapping(value={"/ventas"})
    public Ventas registrarVenta(@RequestBody Ventas venta) {
        return this.serviceVentas.registrarVenta(venta);
    }

    @PutMapping(value={"/ventas"})
    public Ventas modificarVenta(@RequestBody Ventas ventaActualizada) {
        return this.serviceVentas.modificarVenta(ventaActualizada);
    }

    @DeleteMapping(value={"/ventas/{id}"})
    public String anularVenta(@PathVariable Integer id) {
        this.serviceVentas.anularVenta(id);
        return "Venta anulada (eliminaci\u00f3n l\u00f3gica)";
    }
}

