/*
 * Decompiled with CFR 0.152.
 */
package web.Regional_Api.entity;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import web.Regional_Api.entity.Pedido;

@Entity
@Table(name="detalle_pedido")
public class DetallePedido
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id_detalle")
    private Integer idDetalle;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="id_pedido", nullable=false)
    private Pedido pedido;
    @Column(name="id_plato", nullable=false)
    private Integer idPlato;
    @Column(name="cantidad", nullable=false)
    private Integer cantidad;
    @Column(name="precio_unitario", precision=10, scale=2, nullable=false)
    private BigDecimal precioUnitario;
    @Column(name="subtotal", precision=10, scale=2, nullable=false)
    private BigDecimal subtotal;

    public DetallePedido() {
    }

    public DetallePedido(Pedido pedido, Integer idPlato, Integer cantidad, BigDecimal precioUnitario) {
        this.pedido = pedido;
        this.idPlato = idPlato;
        this.cantidad = cantidad;
        this.precioUnitario = precioUnitario;
        if (cantidad != null && precioUnitario != null) {
            this.subtotal = precioUnitario.multiply(new BigDecimal(cantidad));
        }
    }

    public void calcularSubtotal() {
        if (this.cantidad != null && this.precioUnitario != null) {
            this.subtotal = this.precioUnitario.multiply(new BigDecimal(this.cantidad));
        }
    }

    public Integer getIdDetalle() {
        return this.idDetalle;
    }

    public void setIdDetalle(Integer idDetalle) {
        this.idDetalle = idDetalle;
    }

    public Pedido getPedido() {
        return this.pedido;
    }

    public void setPedido(Pedido pedido) {
        this.pedido = pedido;
    }

    public Integer getIdPlato() {
        return this.idPlato;
    }

    public void setIdPlato(Integer idPlato) {
        this.idPlato = idPlato;
    }

    public Integer getCantidad() {
        return this.cantidad;
    }

    public void setCantidad(Integer cantidad) {
        this.cantidad = cantidad;
        this.calcularSubtotal();
    }

    public BigDecimal getPrecioUnitario() {
        return this.precioUnitario;
    }

    public void setPrecioUnitario(BigDecimal precioUnitario) {
        this.precioUnitario = precioUnitario;
        this.calcularSubtotal();
    }

    public BigDecimal getSubtotal() {
        return this.subtotal;
    }

    public void setSubtotal(BigDecimal subtotal) {
        this.subtotal = subtotal;
    }

    public String toString() {
        return "DetallePedido [idDetalle=" + String.valueOf(this.idDetalle) + ", idPlato=" + String.valueOf(this.idPlato) + ", cantidad=" + String.valueOf(this.cantidad) + ", precioUnitario=" + String.valueOf(this.precioUnitario) + ", subtotal=" + String.valueOf(this.subtotal) + "]";
    }
}

