/*
 * Decompiled with CFR 0.152.
 */
package web.Regional_Api.entity;

import com.fasterxml.jackson.annotation.JsonBackReference;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.PrePersist;
import jakarta.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import web.Regional_Api.entity.Restaurante;

@Entity
@Table(name="pagos_suscripcion")
public class PagoSuscripcion
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id_pago")
    private Long idPago;
    @JsonBackReference
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="id_restaurante", nullable=false)
    private Restaurante restaurante;
    @Column(name="monto", nullable=false, precision=10, scale=2)
    private BigDecimal monto;
    @Column(name="fecha_pago", nullable=false)
    private LocalDateTime fechaPago;
    @Column(name="periodo_cubierto", length=100)
    private String periodoCubierto;
    @Column(name="metodo_pago", length=50)
    private String metodoPago;
    @Column(name="url_comprobante", length=255)
    private String comprobanteUrl;
    @Column(name="estado", length=20)
    private String estado;
    @Column(name="fecha_aprobacion")
    private LocalDateTime fechaAprobacion;
    @Column(name="observaciones", columnDefinition="TEXT")
    private String observaciones;

    public PagoSuscripcion() {
    }

    public PagoSuscripcion(Long idPago, Restaurante restaurante, BigDecimal monto, LocalDateTime fechaPago, String estado) {
        this.idPago = idPago;
        this.restaurante = restaurante;
        this.monto = monto;
        this.fechaPago = fechaPago;
        this.estado = estado;
    }

    public Long getIdPago() {
        return this.idPago;
    }

    public void setIdPago(Long idPago) {
        this.idPago = idPago;
    }

    public Restaurante getRestaurante() {
        return this.restaurante;
    }

    public void setRestaurante(Restaurante restaurante) {
        this.restaurante = restaurante;
    }

    public BigDecimal getMonto() {
        return this.monto;
    }

    public void setMonto(BigDecimal monto) {
        this.monto = monto;
    }

    public LocalDateTime getFechaPago() {
        return this.fechaPago;
    }

    public void setFechaPago(LocalDateTime fechaPago) {
        this.fechaPago = fechaPago;
    }

    public String getComprobanteUrl() {
        return this.comprobanteUrl;
    }

    public void setComprobanteUrl(String comprobanteUrl) {
        this.comprobanteUrl = comprobanteUrl;
    }

    public String getEstado() {
        return this.estado;
    }

    public void setEstado(String estado) {
        this.estado = estado;
    }

    public String getObservaciones() {
        return this.observaciones;
    }

    public void setObservaciones(String observaciones) {
        this.observaciones = observaciones;
    }

    public String getPeriodoCubierto() {
        return this.periodoCubierto;
    }

    public void setPeriodoCubierto(String periodoCubierto) {
        this.periodoCubierto = periodoCubierto;
    }

    public String getMetodoPago() {
        return this.metodoPago;
    }

    public void setMetodoPago(String metodoPago) {
        this.metodoPago = metodoPago;
    }

    public LocalDateTime getFechaAprobacion() {
        return this.fechaAprobacion;
    }

    public void setFechaAprobacion(LocalDateTime fechaAprobacion) {
        this.fechaAprobacion = fechaAprobacion;
    }

    @PrePersist
    public void prePersist() {
        if (this.fechaPago == null) {
            this.fechaPago = LocalDateTime.now();
        }
        if (this.estado == null) {
            this.estado = "PENDIENTE";
        }
    }

    public String toString() {
        return "PagoSuscripcion [idPago=" + String.valueOf(this.idPago) + ", restaurante=" + String.valueOf(this.restaurante) + ", monto=" + String.valueOf(this.monto) + ", fechaPago=" + String.valueOf(this.fechaPago) + ", periodoCubierto=" + this.periodoCubierto + ", metodoPago=" + this.metodoPago + ", comprobanteUrl=" + this.comprobanteUrl + ", estado=" + this.estado + ", fechaAprobacion=" + String.valueOf(this.fechaAprobacion) + ", observaciones=" + this.observaciones + "]";
    }
}

