/*
 * Decompiled with CFR 0.152.
 */
package web.Regional_Api.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import java.time.LocalDateTime;
import web.Regional_Api.entity.SuperAdmin;

@Entity
@Table(name="reportes")
public class Reporte {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id_reporte")
    private Integer idReporte;
    @Column(nullable=false, length=100)
    private String accion;
    @Column(columnDefinition="TEXT")
    private String detalle;
    @Column(name="ip_origen", length=50)
    private String ipOrigen;
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Column(nullable=false)
    private LocalDateTime fecha;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="id_superadmin", nullable=false)
    @JsonIgnoreProperties(value={"password", "tokenLogin", "reportes", "hibernateLazyInitializer", "handler"})
    private SuperAdmin superAdmin;

    public Reporte() {
        this.fecha = LocalDateTime.now();
    }

    public Reporte(String accion, String detalle, String ipOrigen, SuperAdmin superAdmin) {
        this.accion = accion;
        this.detalle = detalle;
        this.ipOrigen = ipOrigen;
        this.superAdmin = superAdmin;
        this.fecha = LocalDateTime.now();
    }

    public Integer getIdReporte() {
        return this.idReporte;
    }

    public void setIdReporte(Integer idReporte) {
        this.idReporte = idReporte;
    }

    public String getAccion() {
        return this.accion;
    }

    public void setAccion(String accion) {
        this.accion = accion;
    }

    public String getDetalle() {
        return this.detalle;
    }

    public void setDetalle(String detalle) {
        this.detalle = detalle;
    }

    public String getIpOrigen() {
        return this.ipOrigen;
    }

    public void setIpOrigen(String ipOrigen) {
        this.ipOrigen = ipOrigen;
    }

    public LocalDateTime getFecha() {
        return this.fecha;
    }

    public void setFecha(LocalDateTime fecha) {
        this.fecha = fecha;
    }

    public SuperAdmin getSuperAdmin() {
        return this.superAdmin;
    }

    public void setSuperAdmin(SuperAdmin superAdmin) {
        this.superAdmin = superAdmin;
    }
}

