/*
 * Decompiled with CFR 0.152.
 */
package web.Regional_Api.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonManagedReference;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import web.Regional_Api.entity.PagoSuscripcion;
import web.Regional_Api.entity.Sucursales;

@Entity
@Table(name="restaurantes")
public class Restaurante
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id_restaurante")
    private Integer idRestaurante;
    @Column(name="nombre", nullable=false, length=100)
    private String nombre;
    @Column(name="ruc", length=20)
    private String ruc;
    @Column(name="direccion_principal", length=200)
    private String direccion;
    @Column(name="logo_url", length=255)
    private String logoUrl;
    @Column(name="simbolo_moneda", length=10)
    private String simboloMoneda;
    @Column(name="tasa_igv", precision=5, scale=2)
    private BigDecimal tasaIgv;
    @Column(name="email_contacto", length=100)
    private String emailContacto;
    @Column(name="estado")
    private Integer estado;
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Column(name="fecha_creacion", nullable=false)
    private LocalDateTime fechaCreacion;
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Column(name="fecha_vencimiento", nullable=false)
    private LocalDateTime fechaVencimiento;
    @JsonManagedReference
    @OneToMany(mappedBy="restaurante", cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    private List<Sucursales> sucursales;
    @JsonManagedReference
    @OneToMany(mappedBy="restaurante", cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    private List<PagoSuscripcion> pagosSuscripcion;

    public Restaurante() {
    }

    public Restaurante(Integer idRestaurante, String nombre, String direccion, String telefono, Integer estado) {
        this.idRestaurante = idRestaurante;
        this.nombre = nombre;
        this.direccion = direccion;
        this.estado = estado;
    }

    public Integer getIdRestaurante() {
        return this.idRestaurante;
    }

    public void setIdRestaurante(Integer idRestaurante) {
        this.idRestaurante = idRestaurante;
    }

    public String getNombre() {
        return this.nombre;
    }

    public void setNombre(String nombre) {
        this.nombre = nombre;
    }

    public String getDireccion() {
        return this.direccion;
    }

    public String getRuc() {
        return this.ruc;
    }

    public void setRuc(String ruc) {
        this.ruc = ruc;
    }

    public void setDireccion(String direccion) {
        this.direccion = direccion;
    }

    public Integer getEstado() {
        return this.estado;
    }

    public void setEstado(Integer estado) {
        this.estado = estado;
    }

    public List<Sucursales> getSucursales() {
        return this.sucursales;
    }

    public void setSucursales(List<Sucursales> sucursales) {
        this.sucursales = sucursales;
    }

    public String getLogoUrl() {
        return this.logoUrl;
    }

    public void setLogoUrl(String logoUrl) {
        this.logoUrl = logoUrl;
    }

    public String getSimboloMoneda() {
        return this.simboloMoneda;
    }

    public void setSimboloMoneda(String simboloMoneda) {
        this.simboloMoneda = simboloMoneda;
    }

    public BigDecimal getTasaIgv() {
        return this.tasaIgv;
    }

    public void setTasaIgv(BigDecimal tasaIgv) {
        this.tasaIgv = tasaIgv;
    }

    public String getEmailContacto() {
        return this.emailContacto;
    }

    public void setEmailContacto(String emailContacto) {
        this.emailContacto = emailContacto;
    }

    public LocalDateTime getFechaCreacion() {
        return this.fechaCreacion;
    }

    public void setFechaCreacion(LocalDateTime fechaCreacion) {
        this.fechaCreacion = fechaCreacion;
    }

    public LocalDateTime getFechaVencimiento() {
        return this.fechaVencimiento;
    }

    public void setFechaVencimiento(LocalDateTime fechaVencimiento) {
        this.fechaVencimiento = fechaVencimiento;
    }

    public List<PagoSuscripcion> getPagosSuscripcion() {
        return this.pagosSuscripcion;
    }

    public void setPagosSuscripcion(List<PagoSuscripcion> pagosSuscripcion) {
        this.pagosSuscripcion = pagosSuscripcion;
    }

    public String toString() {
        return "Restaurante [idRestaurante=" + String.valueOf(this.idRestaurante) + ", nombre=" + this.nombre + ",ruc=" + this.ruc + ", direccion=" + this.direccion + ", logoUrl=" + this.logoUrl + ", simboloMoneda=" + this.simboloMoneda + ", tasaIgv=" + String.valueOf(this.tasaIgv) + ", emailContacto=" + this.emailContacto + ", estado=" + String.valueOf(this.estado) + ", fechaCreacion=" + String.valueOf(this.fechaCreacion) + ", fechaVencimiento=" + String.valueOf(this.fechaVencimiento) + "]";
    }
}

