/*
 * Decompiled with CFR 0.152.
 */
package web.Regional_Api.entity;

import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;
import web.Regional_Api.entity.Ventas;

@Entity
@Table(name="ventas")
@SQLDelete(sql="UPDATE ventas SET estado=0 WHERE id_venta=?")
@Where(clause="estado=1")
public class Ventas {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id_venta")
    private Integer idVenta;
    @Column(name="id_pedido", nullable=false)
    private Integer idPedido;
    @Column(name="id_sesion", nullable=false)
    private Integer idSesion;
    @Column(name="id_cliente")
    private Integer idCliente;
    @Convert(converter=TipoComprobanteConverter.class)
    @Column(name="tipo_comprobante", nullable=false)
    private TipoComprobante tipoComprobante;
    @Column(name="serie_comprobante", length=5)
    private String serieComprobante;
    @Column(name="numero_comprobante")
    private Integer numeroComprobante;
    @Column(name="monto_total", nullable=false, precision=10, scale=2)
    private BigDecimal montoTotal;
    @Column(precision=10, scale=2)
    private BigDecimal impuestos;
    @Convert(converter=MetodoPagoConverter.class)
    @Column(name="metodo_pago", nullable=false)
    private MetodoPago metodoPago;
    @Column(name="fecha_venta", nullable=false)
    private LocalDateTime fechaVenta = LocalDateTime.now();
    @Column(nullable=false)
    private Integer estado = 1;

    public Integer getIdVenta() {
        return this.idVenta;
    }

    public void setIdVenta(Integer idVenta) {
        this.idVenta = idVenta;
    }

    public Integer getIdPedido() {
        return this.idPedido;
    }

    public void setIdPedido(Integer idPedido) {
        this.idPedido = idPedido;
    }

    public Integer getIdSesion() {
        return this.idSesion;
    }

    public void setIdSesion(Integer idSesion) {
        this.idSesion = idSesion;
    }

    public Integer getIdCliente() {
        return this.idCliente;
    }

    public void setIdCliente(Integer idCliente) {
        this.idCliente = idCliente;
    }

    public TipoComprobante getTipoComprobante() {
        return this.tipoComprobante;
    }

    public void setTipoComprobante(TipoComprobante tipoComprobante) {
        this.tipoComprobante = tipoComprobante;
    }

    public String getSerieComprobante() {
        return this.serieComprobante;
    }

    public void setSerieComprobante(String serieComprobante) {
        this.serieComprobante = serieComprobante;
    }

    public Integer getNumeroComprobante() {
        return this.numeroComprobante;
    }

    public void setNumeroComprobante(Integer numeroComprobante) {
        this.numeroComprobante = numeroComprobante;
    }

    public BigDecimal getMontoTotal() {
        return this.montoTotal;
    }

    public void setMontoTotal(BigDecimal montoTotal) {
        this.montoTotal = montoTotal;
    }

    public BigDecimal getImpuestos() {
        return this.impuestos;
    }

    public void setImpuestos(BigDecimal impuestos) {
        this.impuestos = impuestos;
    }

    public MetodoPago getMetodoPago() {
        return this.metodoPago;
    }

    public void setMetodoPago(MetodoPago metodoPago) {
        this.metodoPago = metodoPago;
    }

    public LocalDateTime getFechaVenta() {
        return this.fechaVenta;
    }

    public void setFechaVenta(LocalDateTime fechaVenta) {
        this.fechaVenta = fechaVenta;
    }

    public Integer getEstado() {
        return this.estado;
    }

    public void setEstado(Integer estado) {
        this.estado = estado;
    }
}

