/*
 * Decompiled with CFR 0.152.
 */
package web.Regional_Api.repository;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;
import web.Regional_Api.entity.Pedido;

@Repository
public interface PedidoRepository
extends JpaRepository<Pedido, Integer> {
    public List<Pedido> findByIdSucursal(Integer var1);

    public List<Pedido> findByIdUsuario(Integer var1);

    public List<Pedido> findByIdMesa(Integer var1);

    public List<Pedido> findByEstadoPedido(String var1);

    public List<Pedido> findByTipoPedido(String var1);

    @Query(value="SELECT p FROM Pedido p WHERE p.fechaHora BETWEEN :fechaInicio AND :fechaFin ORDER BY p.fechaHora DESC")
    public List<Pedido> buscarPorFecha(@Param(value="fechaInicio") LocalDateTime var1, @Param(value="fechaFin") LocalDateTime var2);

    @Query(value="SELECT p FROM Pedido p WHERE p.idSucursal = :idSucursal AND p.estadoPedido = :estadoPedido ORDER BY p.fechaHora DESC")
    public List<Pedido> buscarPorSucursalYEstado(@Param(value="idSucursal") Integer var1, @Param(value="estadoPedido") String var2);

    @Query(value="SELECT p FROM Pedido p WHERE p.idUsuario = :idUsuario AND p.estadoPedido != 'Cancelado' ORDER BY p.fechaHora DESC")
    public List<Pedido> buscarPorUsuarioActivos(@Param(value="idUsuario") Integer var1);

    @Query(value="SELECT p FROM Pedido p WHERE p.idSucursal = :idSucursal AND p.estadoPedido != 'Cancelado' ORDER BY p.fechaHora DESC")
    public List<Pedido> buscarPedidosActivosBySucursal(@Param(value="idSucursal") Integer var1);

    @Query(value="SELECT * FROM pedidos WHERE id_mesa = :idMesa AND estado_pedido != 'Cancelado' ORDER BY fecha_hora DESC LIMIT 1", nativeQuery=true)
    public Optional<Pedido> findUltimoPedidoActivoByMesa(@Param(value="idMesa") Integer var1);

    @Query(value="SELECT p FROM Pedido p WHERE p.nombreCliente LIKE %:nombreCliente%")
    public List<Pedido> buscarPorNombreCliente(@Param(value="nombreCliente") String var1);

    @Query(value="SELECT DISTINCT p FROM Pedido p JOIN p.detalles dp WHERE dp.idPlato = :idPlato")
    public List<Pedido> buscarPorPlato(@Param(value="idPlato") Integer var1);
}

