/*
 * Decompiled with CFR 0.152.
 */
package web.Regional_Api.repository;

import java.util.List;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;
import web.Regional_Api.entity.Plato;

@Repository
public interface PlatoRepository
extends JpaRepository<Plato, Integer> {
    @Query(value="SELECT p FROM Plato p WHERE p.categoria.id_categoria = :id_categoria")
    public List<Plato> buscarPorCategoria(@Param(value="id_categoria") Integer var1);

    @Query(value="SELECT p FROM Plato p WHERE p.categoria.id_categoria = :id_categoria AND p.estado = 1")
    public List<Plato> platosDisponiblesPorCategoria(@Param(value="id_categoria") Integer var1);

    @Query(value="SELECT p FROM Plato p WHERE LOWER(p.nombre) LIKE LOWER(CONCAT('%', :nombre, '%'))")
    public List<Plato> buscarPorNombre(@Param(value="nombre") String var1);

    @Query(value="SELECT p FROM Plato p WHERE p.precio <= :precio_maximo")
    public List<Plato> buscarPorPrecioMenorIgual(@Param(value="precio_maximo") Double var1);

    public List<Plato> findByEstado(Integer var1);

    @Query(value="SELECT p FROM Plato p WHERE p.categoria.id_categoria = :idCategoria")
    public List<Plato> findByIdCategoria(@Param(value="idCategoria") Integer var1);
}

