/*
 * Decompiled with CFR 0.152.
 */
package web.Regional_Api.repository;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;
import web.Regional_Api.entity.Restaurante;

@Repository
public interface RestauranteRepository
extends JpaRepository<Restaurante, Integer> {
    public Optional<Restaurante> findByRuc(String var1);

    public List<Restaurante> findByEstado(Integer var1);

    public List<Restaurante> findByNombreContainingIgnoreCase(String var1);

    @Query(value="SELECT r FROM Restaurante r WHERE r.fechaVencimiento < :ahora AND r.estado = 1")
    public List<Restaurante> findRestaurantesConSuscripcionVencida(@Param(value="ahora") LocalDateTime var1);

    @Query(value="SELECT r FROM Restaurante r WHERE r.fechaVencimiento BETWEEN :desde AND :hasta AND r.estado = 1")
    public List<Restaurante> findRestaurantesProximoVencimiento(@Param(value="desde") LocalDateTime var1, @Param(value="hasta") LocalDateTime var2);

    public long countByEstado(Integer var1);

    public Optional<Restaurante> findByEmailContacto(String var1);
}

