/*
 * Decompiled with CFR 0.152.
 */
package web.Regional_Api.security;

import jakarta.servlet.Filter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.annotation.web.configurers.SessionManagementConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import web.Regional_Api.security.ExternalAuthFilter;
import web.Regional_Api.security.InternalAuthFilter;
import web.Regional_Api.security.PublicSecurityConfig;

@Configuration
@Order(value=1)
public class ApiSecurityConfig {
    @Autowired
    private InternalAuthFilter internalAuthFilter;
    @Autowired
    private ExternalAuthFilter externalAuthFilter;

    @Bean
    public SecurityFilterChain apiSecurityFilterChain(HttpSecurity http) throws Exception {
        http.securityMatcher(new String[]{"/restful/**", "/api/**", "/regional/**", "/perfiles/**", "/modulos/**", "/accesos/**"}).csrf(csrf -> {
            HttpSecurityBuilder httpSecurityBuilder = csrf.disable();
        }).cors(Customizer.withDefaults()).sessionManagement(session -> {
            SessionManagementConfigurer sessionManagementConfigurer = session.sessionCreationPolicy(SessionCreationPolicy.STATELESS);
        }).authorizeHttpRequests(auth -> {
            AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry authorizationManagerRequestMatcherRegistry = ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)auth.requestMatchers(PublicSecurityConfig.PUBLIC_ENDPOINTS)).permitAll().anyRequest()).authenticated();
        }).addFilterBefore((Filter)this.internalAuthFilter, UsernamePasswordAuthenticationFilter.class).addFilterAfter((Filter)this.externalAuthFilter, InternalAuthFilter.class);
        return (SecurityFilterChain)http.build();
    }
}

