/*
 * Decompiled with CFR 0.152.
 */
package web.Regional_Api.security;

import jakarta.servlet.FilterChain;
import jakarta.servlet.GenericFilter;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.Collections;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;
import web.Regional_Api.entity.Registros;
import web.Regional_Api.repository.RegistrosRepository;
import web.Regional_Api.security.PublicSecurityConfig;

@Component
@Order(value=2)
public class ExternalAuthFilter
extends GenericFilter {
    @Autowired
    private RegistrosRepository registrosRepository;

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        String requestURI = request.getRequestURI();
        if (PublicSecurityConfig.isPublicEndpoint((String)requestURI)) {
            chain.doFilter(req, res);
            return;
        }
        if (requestURI.startsWith("/restful/superadmin")) {
            chain.doFilter(req, res);
            return;
        }
        if (SecurityContextHolder.getContext().getAuthentication() != null) {
            chain.doFilter(req, res);
            return;
        }
        String header = request.getHeader("Authorization");
        if (header != null && header.startsWith("Bearer ")) {
            String token = header.substring(7);
            try {
                Optional<Registros> match = this.registrosRepository.findAll().stream().filter(r -> token.equals(r.getAccess_token())).findFirst();
                if (match.isPresent()) {
                    Registros registro = match.get();
                    String clienteId = registro.getid_usuario();
                    UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken((Object)clienteId, null, Collections.emptyList());
                    SecurityContextHolder.getContext().setAuthentication((Authentication)auth);
                    System.out.println("\u2705 Usuario externo autenticado: " + clienteId);
                }
            }
            catch (Exception e) {
                System.err.println("\u274c Error en ExternalAuthFilter: " + e.getMessage());
            }
        }
        chain.doFilter(req, res);
    }
}

