/*
 * Decompiled with CFR 0.152.
 */
package web.Regional_Api.security;

import jakarta.servlet.FilterChain;
import jakarta.servlet.GenericFilter;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Collections;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;
import web.Regional_Api.entity.Usuarios;
import web.Regional_Api.repository.UsuarioRepository;
import web.Regional_Api.security.JwtUtil;
import web.Regional_Api.security.PublicSecurityConfig;

@Component
@Order(value=1)
public class InternalAuthFilter
extends GenericFilter {
    @Autowired
    private JwtUtil jwtUtil;
    @Autowired
    private UsuarioRepository usuarioRepository;

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        String requestURI = request.getRequestURI();
        if (PublicSecurityConfig.isPublicEndpoint((String)requestURI)) {
            chain.doFilter(req, res);
            return;
        }
        System.out.println("\ud83d\udd0d InternalAuthFilter - URI: " + requestURI);
        if (requestURI.startsWith("/restful/superadmin")) {
            System.out.println("\u23e9 InternalAuthFilter SKIPPING SuperAdmin path");
            chain.doFilter(req, res);
            return;
        }
        if (SecurityContextHolder.getContext().getAuthentication() != null) {
            chain.doFilter(req, res);
            return;
        }
        String header = request.getHeader("Authorization");
        if (header != null && header.startsWith("Bearer ")) {
            String token = header.substring(7);
            try {
                String username;
                Optional usuarioOpt;
                if (this.jwtUtil.validarToken(token) && (usuarioOpt = this.usuarioRepository.findByNombreUsuarioLogin(username = this.jwtUtil.extraerClienteId(token))).isPresent()) {
                    Usuarios usuario = (Usuarios)usuarioOpt.get();
                    if (usuario.getEstado() == null || usuario.getEstado() != 1) {
                        response.setStatus(403);
                        response.setContentType("application/json");
                        response.getWriter().write("{\"error\":\"Usuario inactivo\",\"type\":\"INACTIVE_USER\"}");
                        return;
                    }
                    UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken((Object)username, null, Collections.emptyList());
                    SecurityContextHolder.getContext().setAuthentication((Authentication)auth);
                    System.out.println("\u2705 Usuario interno autenticado: " + username);
                }
            }
            catch (Exception e) {
                System.err.println("\u274c Error en InternalAuthFilter: " + e.getMessage());
            }
        }
        chain.doFilter(req, res);
    }
}

