/*
 * Decompiled with CFR 0.152.
 */
package web.Regional_Api.security;

import jakarta.servlet.FilterChain;
import jakarta.servlet.GenericFilter;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Collections;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;
import web.Regional_Api.entity.Registros;
import web.Regional_Api.entity.SuperAdmin;
import web.Regional_Api.repository.RegistrosRepository;
import web.Regional_Api.repository.SuperAdminRepository;
import web.Regional_Api.repository.UsuarioRepository;
import web.Regional_Api.security.JwtUtil;

@Component
public class JwtFilter
extends GenericFilter {
    @Autowired
    private RegistrosRepository registrosRepository;
    @Autowired
    private JwtUtil jwtUtil;
    @Autowired
    private UsuarioRepository usuarioRepository;
    @Autowired
    private SuperAdminRepository superAdminRepository;

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        String path = request.getRequestURI();
        System.out.println("\ud83d\udd0d JwtFilter - Path: " + path);
        if (path.startsWith("/restful/superadmin")) {
            System.out.println("\u23e9 JwtFilter SKIPPING SuperAdmin path: " + path);
            chain.doFilter(req, res);
            return;
        }
        if (path.equals("/restful/usuarios/login") || path.equals("/restful/token") || path.equals("/restful/registros")) {
            System.out.println("\u2705 Endpoint p\u00fablico - permitiendo acceso sin token");
            chain.doFilter(req, res);
            return;
        }
        String header = request.getHeader("Authorization");
        if (header != null && header.startsWith("Bearer ")) {
            String token = header.substring(7);
            System.out.println("\ud83d\udd11 Token recibido: " + token.substring(0, Math.min(20, token.length())) + "...");
            Optional<Registros> matchRegistro = this.registrosRepository.findAll().stream().filter(r -> token.equals(r.getAccess_token())).findFirst();
            if (matchRegistro.isPresent()) {
                String clienteId = matchRegistro.get().getid_usuario();
                UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken((Object)clienteId, null, Collections.emptyList());
                SecurityContextHolder.getContext().setAuthentication((Authentication)auth);
                System.out.println("\u2705 Autenticado como Usuario Legacy: " + clienteId);
                chain.doFilter(req, res);
                return;
            }
            if (this.jwtUtil.validarToken(token)) {
                String email = this.jwtUtil.extraerClienteId(token);
                System.out.println("\ud83d\udce7 Email extra\u00eddo del JWT: " + email);
                Optional superAdminOpt = this.superAdminRepository.findByEmail(email);
                if (superAdminOpt.isPresent()) {
                    SuperAdmin superAdmin = (SuperAdmin)superAdminOpt.get();
                    if (superAdmin.getEstado() != null && superAdmin.getEstado() == 1) {
                        UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken((Object)email, null, Collections.emptyList());
                        SecurityContextHolder.getContext().setAuthentication((Authentication)auth);
                        System.out.println("\u2705 Autenticado como SuperAdmin: " + email);
                        chain.doFilter(req, res);
                        return;
                    }
                    System.out.println("\u274c SuperAdmin inactivo: " + email);
                    response.sendError(403, "Cuenta de SuperAdmin inactiva");
                    return;
                }
                Optional usuarioOpt = this.usuarioRepository.findByNombreUsuarioLogin(email);
                if (usuarioOpt.isPresent()) {
                    UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken((Object)email, null, Collections.emptyList());
                    SecurityContextHolder.getContext().setAuthentication((Authentication)auth);
                    System.out.println("\u2705 Autenticado como Usuario: " + email);
                    chain.doFilter(req, res);
                    return;
                }
                System.out.println("\u274c Email del JWT no encontrado en ninguna tabla");
            } else {
                System.out.println("\u274c Token JWT inv\u00e1lido o expirado");
            }
        } else {
            System.out.println("\u26a0\ufe0f No se encontr\u00f3 header Authorization");
        }
        if (path.startsWith("/restful/superadmin/")) {
            System.out.println("\u274c Acceso denegado a endpoint de SuperAdmin");
            response.sendError(401, "Token inv\u00e1lido o expirado");
            return;
        }
        chain.doFilter(req, res);
    }
}

