/*
 * Decompiled with CFR 0.152.
 */
package web.Regional_Api.security;

import jakarta.annotation.PostConstruct;
import jakarta.servlet.FilterChain;
import jakarta.servlet.GenericFilter;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;
import web.Regional_Api.entity.SuperAdmin;
import web.Regional_Api.repository.SuperAdminRepository;
import web.Regional_Api.security.SuperAdminJwtUtil;

@Component
public class SuperAdminJwtFilter
extends GenericFilter {
    @Autowired
    private SuperAdminJwtUtil jwtUtil;
    @Autowired
    private SuperAdminRepository superAdminRepository;

    @PostConstruct
    public void init() {
        System.out.println("\ud83d\ude80 SUPERADMIN JWT FILTER CARGADO CORRECTAMENTE \ud83d\ude80");
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        String path = request.getRequestURI();
        if (!path.startsWith("/restful/superadmin")) {
            chain.doFilter(req, res);
            return;
        }
        System.out.println("\ud83c\udfaf SuperAdminFilter INVOCADO - Path: " + path);
        if (request.getMethod().equalsIgnoreCase("OPTIONS") || path.startsWith("/restful/superadmin/auth/")) {
            chain.doFilter(req, res);
            return;
        }
        String header = request.getHeader("Authorization");
        if (header != null && header.startsWith("Bearer ")) {
            String token = header.substring(7);
            if (this.jwtUtil.validarToken(token)) {
                String username = this.jwtUtil.extraerClienteId(token);
                System.out.println("\ud83d\udd0d V2 Filter: Token valido. Usuario: '" + username + "'");
                Optional superAdminOpt = this.superAdminRepository.findByEmail(username);
                if (superAdminOpt.isPresent()) {
                    System.out.println("\u2705 SuperAdmin encontrado: " + ((SuperAdmin)superAdminOpt.get()).getEmail());
                    if (((SuperAdmin)superAdminOpt.get()).getEstado() == 1) {
                        String finalRole = "ROLE_" + ((SuperAdmin)superAdminOpt.get()).getRol();
                        System.out.println("\ud83d\udd10 V2 AUTH EXITOSA. Rol: " + finalRole);
                        List<SimpleGrantedAuthority> authorities = Collections.singletonList(new SimpleGrantedAuthority(finalRole));
                        UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken((Object)username, null, authorities);
                        SecurityContextHolder.getContext().setAuthentication((Authentication)auth);
                    } else {
                        System.out.println("\u274c SuperAdmin inactivo.");
                    }
                } else {
                    System.out.println("\u26a0\ufe0f Token valido, pero usuario no encontrado en SuperAdmin table.");
                }
            } else {
                System.out.println("\u274c Token Invalido o Expirado (Rechazado por JwtUtil)");
            }
        }
        chain.doFilter(req, res);
    }
}

