/*
 * Decompiled with CFR 0.152.
 */
package web.Regional_Api.service;

import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import web.Regional_Api.entity.Modulo;
import web.Regional_Api.entity.Usuarios;
import web.Regional_Api.repository.AccesoRepository;
import web.Regional_Api.repository.ModuloRepository;
import web.Regional_Api.service.jpa.UsuarioService;

@Service
public class AuthorizationService {
    @Autowired
    private UsuarioService usuarioService;
    @Autowired
    private ModuloRepository moduloRepository;
    @Autowired
    private AccesoRepository accesoRepository;

    public boolean userHasAccess(String nombreUsuarioLogin, String nombreModulo) {
        Optional usuarioOpt = this.usuarioService.getUsuarioByLogin(nombreUsuarioLogin);
        if (usuarioOpt.isEmpty()) {
            return false;
        }
        Optional moduloOpt = this.moduloRepository.findByNombreModulo(nombreModulo);
        if (moduloOpt.isEmpty()) {
            return false;
        }
        Usuarios usuario = (Usuarios)usuarioOpt.get();
        Modulo modulo = (Modulo)moduloOpt.get();
        Integer rolId = usuario.getRolId();
        if (rolId == null) {
            return false;
        }
        return this.accesoRepository.existsByIdModuloAndIdPerfilAndEstado(modulo.getIdModulo(), rolId, Integer.valueOf(1));
    }
}

