/*
 * Decompiled with CFR 0.152.
 */
package web.Regional_Api.service;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import web.Regional_Api.entity.PagoSuscripcion;
import web.Regional_Api.entity.PagoSuscripcionDTO;
import web.Regional_Api.entity.Restaurante;
import web.Regional_Api.repository.PagoSuscripcionRepository;
import web.Regional_Api.repository.RestauranteRepository;

@Service
@Transactional
public class PagoSuscripcionService {
    @Autowired
    private PagoSuscripcionRepository pagoRepository;
    @Autowired
    private RestauranteRepository restauranteRepository;

    public List<PagoSuscripcionDTO> obtenerTodos() {
        return this.pagoRepository.findAll().stream().map(arg_0 -> this.convertirADTO(arg_0)).collect(Collectors.toList());
    }

    public PagoSuscripcionDTO obtenerPorId(Long idPago) {
        Optional pago = this.pagoRepository.findById((Object)idPago);
        return pago.map(arg_0 -> this.convertirADTO(arg_0)).orElse(null);
    }

    public List<PagoSuscripcionDTO> obtenerPagosPorRestaurante(Integer idRestaurante) {
        return this.pagoRepository.findByRestauranteIdRestaurante(idRestaurante).stream().map(arg_0 -> this.convertirADTO(arg_0)).collect(Collectors.toList());
    }

    public PagoSuscripcionDTO obtenerUltimoPago(Integer idRestaurante) {
        Optional pago = this.pagoRepository.findUltimoPagoRestaurante(idRestaurante);
        return pago.map(arg_0 -> this.convertirADTO(arg_0)).orElse(null);
    }

    public PagoSuscripcionDTO crearPago(Integer idRestaurante, PagoSuscripcionDTO dto) {
        Restaurante restaurante = (Restaurante)this.restauranteRepository.findById((Object)idRestaurante).orElseThrow(() -> new RuntimeException("Restaurante no encontrado"));
        Optional pagoExistente = this.pagoRepository.findPagoByRestauranteAndPeriodo(idRestaurante, dto.getPeriodoCubierto());
        if (pagoExistente.isPresent()) {
            throw new RuntimeException("Ya existe un pago registrado para este per\u00edodo");
        }
        PagoSuscripcion pago = new PagoSuscripcion();
        pago.setRestaurante(restaurante);
        pago.setMonto(new BigDecimal(dto.getMonto().toString()));
        pago.setFechaPago(LocalDateTime.now());
        pago.setPeriodoCubierto(dto.getPeriodoCubierto());
        pago.setMetodoPago(dto.getMetodoPago());
        pago.setComprobanteUrl(dto.getComprobanteUrl());
        pago.setEstado("PENDIENTE");
        pago.setObservaciones(dto.getObservaciones());
        PagoSuscripcion saved = (PagoSuscripcion)this.pagoRepository.save((Object)pago);
        return this.convertirADTO(saved);
    }

    public PagoSuscripcionDTO aprobarPago(Long idPago) {
        LocalDateTime nuevaFecha;
        PagoSuscripcion pago = (PagoSuscripcion)this.pagoRepository.findById((Object)idPago).orElseThrow(() -> new RuntimeException("Pago no encontrado"));
        if (!"PENDIENTE".equals(pago.getEstado())) {
            throw new RuntimeException("Solo se pueden aprobar pagos en estado PENDIENTE");
        }
        pago.setEstado("APROBADO");
        pago.setFechaAprobacion(LocalDateTime.now());
        Restaurante restaurante = pago.getRestaurante();
        if (restaurante != null) {
            nuevaFecha = restaurante.getFechaVencimiento();
            if (nuevaFecha == null) {
                nuevaFecha = LocalDateTime.now();
            }
        } else {
            throw new RuntimeException("Restaurante no encontrado para el pago");
        }
        restaurante.setFechaVencimiento(nuevaFecha.plusDays(30L));
        PagoSuscripcion updated = (PagoSuscripcion)this.pagoRepository.save((Object)pago);
        return this.convertirADTO(updated);
    }

    public PagoSuscripcionDTO rechazarPago(Long idPago, String motivo) {
        PagoSuscripcion pago = (PagoSuscripcion)this.pagoRepository.findById((Object)idPago).orElseThrow(() -> new RuntimeException("Pago no encontrado"));
        pago.setEstado("RECHAZADO");
        pago.setFechaAprobacion(LocalDateTime.now());
        pago.setObservaciones(motivo);
        PagoSuscripcion updated = (PagoSuscripcion)this.pagoRepository.save((Object)pago);
        return this.convertirADTO(updated);
    }

    public List<PagoSuscripcionDTO> obtenerPagosPendientes() {
        return this.pagoRepository.findByEstadoOrderByFechaPagoAsc("PENDIENTE").stream().map(arg_0 -> this.convertirADTO(arg_0)).collect(Collectors.toList());
    }

    public List<PagoSuscripcionDTO> obtenerPagosPorEstado(String estado) {
        return this.pagoRepository.findByEstado(estado).stream().map(arg_0 -> this.convertirADTO(arg_0)).collect(Collectors.toList());
    }

    public List<PagoSuscripcionDTO> obtenerPagosRestaurantePorEstado(Integer idRestaurante, String estado) {
        return this.pagoRepository.findByRestauranteIdRestauranteAndEstado(idRestaurante, estado).stream().map(arg_0 -> this.convertirADTO(arg_0)).collect(Collectors.toList());
    }

    public List<PagoSuscripcionDTO> obtenerPagosPorFecha(LocalDateTime desde, LocalDateTime hasta) {
        return this.pagoRepository.findPagosPorFecha(desde, hasta).stream().map(arg_0 -> this.convertirADTO(arg_0)).collect(Collectors.toList());
    }

    public long contarPagosPendientes() {
        return this.pagoRepository.countByEstado("PENDIENTE");
    }

    public PagoSuscripcionDTO actualizarPago(Long idPago, PagoSuscripcionDTO dto) {
        PagoSuscripcion pago = (PagoSuscripcion)this.pagoRepository.findById((Object)idPago).orElseThrow(() -> new RuntimeException("Pago no encontrado"));
        if (!"PENDIENTE".equals(pago.getEstado())) {
            throw new RuntimeException("No se puede actualizar un pago que no est\u00e1 en estado PENDIENTE");
        }
        pago.setMonto(new BigDecimal(dto.getMonto().toString()));
        pago.setMetodoPago(dto.getMetodoPago());
        pago.setComprobanteUrl(dto.getComprobanteUrl());
        pago.setObservaciones(dto.getObservaciones());
        PagoSuscripcion updated = (PagoSuscripcion)this.pagoRepository.save((Object)pago);
        return this.convertirADTO(updated);
    }

    public void eliminarPago(Long idPago) {
        this.pagoRepository.deleteById((Object)idPago);
    }

    private PagoSuscripcionDTO convertirADTO(PagoSuscripcion pago) {
        PagoSuscripcionDTO dto = new PagoSuscripcionDTO();
        dto.setIdPago(pago.getIdPago());
        dto.setIdRestaurante(pago.getRestaurante().getIdRestaurante());
        dto.setMonto(Double.valueOf(pago.getMonto().doubleValue()));
        dto.setFechaPago((Date)Timestamp.valueOf(pago.getFechaPago()));
        dto.setPeriodoCubierto(pago.getPeriodoCubierto());
        dto.setMetodoPago(pago.getMetodoPago());
        dto.setComprobanteUrl(pago.getComprobanteUrl());
        dto.setEstado(pago.getEstado());
        if (pago.getFechaAprobacion() != null) {
            dto.setFechaAprobacion((Date)Timestamp.valueOf(pago.getFechaAprobacion()));
        }
        dto.setObservaciones(pago.getObservaciones());
        return dto;
    }
}

