/*
 * Decompiled with CFR 0.152.
 */
package web.Regional_Api.service;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import web.Regional_Api.entity.Restaurante;
import web.Regional_Api.entity.RestauranteDTO;
import web.Regional_Api.repository.RestauranteRepository;

@Service
@Transactional
public class RestauranteService {
    @Autowired
    private RestauranteRepository restauranteRepository;

    public List<RestauranteDTO> obtenerTodos() {
        return this.restauranteRepository.findAll().stream().map(arg_0 -> this.convertirADTO(arg_0)).collect(Collectors.toList());
    }

    public long contarTodos() {
        return this.restauranteRepository.count();
    }

    public List<Restaurante> buscarTodos() {
        return this.restauranteRepository.findAll();
    }

    public Optional<Restaurante> buscarId(Integer id) {
        return this.restauranteRepository.findById((Object)id);
    }

    public boolean existsByRuc(String ruc) {
        return this.restauranteRepository.findByRuc(ruc).isPresent();
    }

    public Restaurante guardar(Restaurante restaurante) {
        return (Restaurante)this.restauranteRepository.save((Object)restaurante);
    }

    public void eliminar(Integer id) {
        this.restauranteRepository.deleteById((Object)id);
    }

    public RestauranteDTO obtenerPorId(Integer idRestaurante) {
        Optional restaurante = this.restauranteRepository.findById((Object)idRestaurante);
        return restaurante.map(arg_0 -> this.convertirADTO(arg_0)).orElse(null);
    }

    public RestauranteDTO obtenerPorRuc(String ruc) {
        Optional restaurante = this.restauranteRepository.findByRuc(ruc);
        return restaurante.map(arg_0 -> this.convertirADTO(arg_0)).orElse(null);
    }

    public RestauranteDTO crearRestaurante(RestauranteDTO dto) {
        if (this.restauranteRepository.findByRuc(dto.getRuc()).isPresent()) {
            throw new RuntimeException("El RUC " + dto.getRuc() + " ya existe");
        }
        Restaurante restaurante = new Restaurante();
        restaurante.setNombre(dto.getNombre());
        restaurante.setRuc(dto.getRuc());
        restaurante.setDireccion(dto.getDireccion());
        restaurante.setLogoUrl(dto.getLogoUrl());
        restaurante.setSimboloMoneda(dto.getSimboloMoneda());
        restaurante.setTasaIgv(dto.getTasaIgv());
        restaurante.setEmailContacto(dto.getEmailContacto());
        restaurante.setEstado(Integer.valueOf(1));
        restaurante.setFechaCreacion(LocalDateTime.now());
        restaurante.setFechaVencimiento(LocalDateTime.now().plusMonths(1L));
        Restaurante saved = (Restaurante)this.restauranteRepository.save((Object)restaurante);
        return this.convertirADTO(saved);
    }

    public RestauranteDTO actualizarRestaurante(Integer idRestaurante, RestauranteDTO dto) {
        Restaurante restaurante = (Restaurante)this.restauranteRepository.findById((Object)idRestaurante).orElseThrow(() -> new RuntimeException("Restaurante no encontrado"));
        restaurante.setNombre(dto.getNombre());
        restaurante.setDireccion(dto.getDireccion());
        restaurante.setLogoUrl(dto.getLogoUrl());
        restaurante.setSimboloMoneda(dto.getSimboloMoneda());
        restaurante.setTasaIgv(dto.getTasaIgv());
        restaurante.setEmailContacto(dto.getEmailContacto());
        restaurante.setEstado(dto.getEstado());
        Restaurante updated = (Restaurante)this.restauranteRepository.save((Object)restaurante);
        return this.convertirADTO(updated);
    }

    public RestauranteDTO cambiarEstado(Integer idRestaurante, Integer nuevoEstado) {
        Restaurante restaurante = (Restaurante)this.restauranteRepository.findById((Object)idRestaurante).orElseThrow(() -> new RuntimeException("Restaurante no encontrado"));
        restaurante.setEstado(nuevoEstado);
        Restaurante updated = (Restaurante)this.restauranteRepository.save((Object)restaurante);
        return this.convertirADTO(updated);
    }

    public RestauranteDTO renovarSuscripcion(Integer idRestaurante, Integer diasVigencia) {
        Restaurante restaurante = (Restaurante)this.restauranteRepository.findById((Object)idRestaurante).orElseThrow(() -> new RuntimeException("Restaurante no encontrado"));
        LocalDateTime nuevaFechaVencimiento = LocalDateTime.now().plusDays(diasVigencia.intValue());
        restaurante.setFechaVencimiento(nuevaFechaVencimiento);
        restaurante.setEstado(Integer.valueOf(1));
        Restaurante updated = (Restaurante)this.restauranteRepository.save((Object)restaurante);
        return this.convertirADTO(updated);
    }

    public List<RestauranteDTO> obtenerActivos() {
        return this.restauranteRepository.findByEstado(Integer.valueOf(1)).stream().map(arg_0 -> this.convertirADTO(arg_0)).collect(Collectors.toList());
    }

    public List<RestauranteDTO> obtenerConSuscripcionVencida() {
        return this.restauranteRepository.findRestaurantesConSuscripcionVencida(LocalDateTime.now()).stream().map(arg_0 -> this.convertirADTO(arg_0)).collect(Collectors.toList());
    }

    public List<RestauranteDTO> obtenerProximoVencimiento(Integer dias) {
        LocalDateTime ahora = LocalDateTime.now();
        LocalDateTime limite = ahora.plusDays(dias.intValue());
        return this.restauranteRepository.findRestaurantesProximoVencimiento(ahora, limite).stream().map(arg_0 -> this.convertirADTO(arg_0)).collect(Collectors.toList());
    }

    public List<RestauranteDTO> buscarPorNombre(String nombre) {
        return this.restauranteRepository.findByNombreContainingIgnoreCase(nombre).stream().map(arg_0 -> this.convertirADTO(arg_0)).collect(Collectors.toList());
    }

    public void eliminarRestaurante(Integer idRestaurante) {
        this.restauranteRepository.deleteById((Object)idRestaurante);
    }

    private RestauranteDTO convertirADTO(Restaurante restaurante) {
        RestauranteDTO dto = new RestauranteDTO();
        dto.setIdRestaurante(restaurante.getIdRestaurante());
        dto.setNombre(restaurante.getNombre());
        dto.setRuc(restaurante.getRuc());
        dto.setDireccion(restaurante.getDireccion());
        dto.setLogoUrl(restaurante.getLogoUrl());
        dto.setSimboloMoneda(restaurante.getSimboloMoneda());
        dto.setTasaIgv(restaurante.getTasaIgv());
        dto.setEmailContacto(restaurante.getEmailContacto());
        dto.setEstado(restaurante.getEstado());
        dto.setFechaCreacion(restaurante.getFechaCreacion() != null ? restaurante.getFechaCreacion().toString() : null);
        dto.setFechaVencimiento(restaurante.getFechaVencimiento() != null ? restaurante.getFechaVencimiento().toString() : null);
        return dto;
    }
}

