/*
 * Decompiled with CFR 0.152.
 */
package web.Regional_Api.service.jpa;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import web.Regional_Api.dto.AccesoConModuloDTO;
import web.Regional_Api.entity.Acceso;
import web.Regional_Api.entity.Modulo;
import web.Regional_Api.repository.AccesoRepository;
import web.Regional_Api.repository.ModuloRepository;
import web.Regional_Api.service.IAccesoService;

@Service
public class AccesoService
implements IAccesoService {
    @Autowired
    private AccesoRepository accesoRepository;
    @Autowired
    private ModuloRepository moduloRepository;

    public List<Acceso> getAllAccesos() {
        return this.accesoRepository.findAll();
    }

    public Optional<Acceso> getAccesoById(Integer id) {
        return this.accesoRepository.findById((Object)id);
    }

    public Acceso saveAcceso(Acceso acceso) {
        return (Acceso)this.accesoRepository.save((Object)acceso);
    }

    public void deleteAcceso(Integer id) {
        this.accesoRepository.deleteById((Object)id);
    }

    public boolean existeAcceso(Integer idModulo, Integer idPerfil) {
        return this.accesoRepository.existsByIdModuloAndIdPerfilAndEstado(idModulo, idPerfil, Integer.valueOf(1));
    }

    public void deleteAccesosByPerfil(Integer idPerfil) {
        this.accesoRepository.deleteByIdPerfil(idPerfil);
    }

    public List<Acceso> getAccesosByPerfil(Integer idPerfil) {
        return this.accesoRepository.findByIdPerfilAndEstado(idPerfil, Integer.valueOf(1));
    }

    public boolean tieneAcceso(Integer idPerfil, Integer idModulo) {
        return this.accesoRepository.existsByIdModuloAndIdPerfilAndEstado(idModulo, idPerfil, Integer.valueOf(1));
    }

    public List<AccesoConModuloDTO> getAccesosConModuloByPerfil(Integer idPerfil) {
        List accesos = this.accesoRepository.findByIdPerfilAndEstado(idPerfil, Integer.valueOf(1));
        ArrayList<AccesoConModuloDTO> resultado = new ArrayList<AccesoConModuloDTO>();
        for (Acceso acceso : accesos) {
            Modulo modulo = this.moduloRepository.findById((Object)acceso.getIdModulo()).orElse(null);
            if (modulo == null) continue;
            AccesoConModuloDTO dto = new AccesoConModuloDTO(acceso.getIdAcceso(), modulo.getIdModulo(), modulo.getNombreModulo(), modulo.getOrden(), acceso.getIdPerfil(), acceso.getEstado());
            resultado.add(dto);
        }
        resultado.sort((a, b) -> a.getOrden().compareTo(b.getOrden()));
        return resultado;
    }
}

