/*
 * Decompiled with CFR 0.152.
 */
package web.Regional_Api.service.jpa;

import java.time.LocalDateTime;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import web.Regional_Api.entity.BitacoraAccion;
import web.Regional_Api.repository.BitacoraAccionRepository;

@Service
public class BitacoraService {
    @Autowired
    private BitacoraAccionRepository bitacoraRepository;

    public BitacoraAccion registrar(Integer idUsuario, String accion, String tabla, Integer idRegistro, String detalles) {
        BitacoraAccion log = new BitacoraAccion(idUsuario, accion, tabla, idRegistro, detalles);
        return (BitacoraAccion)this.bitacoraRepository.save((Object)log);
    }

    public void logCreacion(Integer idUsuario, String tabla, Integer idRegistro, String detalles) {
        this.registrar(idUsuario, "CREAR", tabla, idRegistro, detalles);
    }

    public void logActualizacion(Integer idUsuario, String tabla, Integer idRegistro, String detalles) {
        this.registrar(idUsuario, "ACTUALIZAR", tabla, idRegistro, detalles);
    }

    public void logEliminacion(Integer idUsuario, String tabla, Integer idRegistro, String detalles) {
        this.registrar(idUsuario, "ELIMINAR", tabla, idRegistro, detalles);
    }

    public void logLogin(Integer idUsuario, String detalles) {
        this.registrar(idUsuario, "LOGIN", "usuario", idUsuario, detalles);
    }

    public void logLogout(Integer idUsuario) {
        this.registrar(idUsuario, "LOGOUT", "usuario", idUsuario, "Cierre de sesi\u00f3n");
    }

    public List<BitacoraAccion> obtenerTodos() {
        return this.bitacoraRepository.findTop50ByOrderByFechaHoraDesc();
    }

    public List<BitacoraAccion> obtenerPorUsuario(Integer idUsuario) {
        return this.bitacoraRepository.findByIdUsuarioOrderByFechaHoraDesc(idUsuario);
    }

    public List<BitacoraAccion> obtenerPorTabla(String tabla) {
        return this.bitacoraRepository.findByTablaAfectadaOrderByFechaHoraDesc(tabla);
    }

    public List<BitacoraAccion> obtenerPorFechas(LocalDateTime inicio, LocalDateTime fin) {
        return this.bitacoraRepository.findByFechaHoraBetweenOrderByFechaHoraDesc(inicio, fin);
    }

    public List<Object[]> estadisticasPorAccion() {
        return this.bitacoraRepository.contarPorAccion();
    }
}

