/*
 * Decompiled with CFR 0.152.
 */
package web.Regional_Api.service.jpa;

import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import web.Regional_Api.entity.Categoria;
import web.Regional_Api.repository.CategoriaRepository;
import web.Regional_Api.service.ICategoriaService;

@Service
@Transactional(readOnly=true)
public class CategoriaService
implements ICategoriaService {
    @Autowired
    private CategoriaRepository repoCategoria;

    public List<Categoria> buscarTodos() {
        return this.repoCategoria.findAll();
    }

    @Transactional
    public Categoria guardar(Categoria categoria) {
        return (Categoria)this.repoCategoria.save((Object)categoria);
    }

    @Transactional
    public Categoria modificar(Categoria categoria) {
        return (Categoria)this.repoCategoria.save((Object)categoria);
    }

    public Optional<Categoria> buscarId(Integer id) {
        return this.repoCategoria.findById((Object)id);
    }

    @Transactional
    public void eliminar(Integer id) {
        this.repoCategoria.deleteById((Object)id);
    }

    public Optional<Categoria> buscarPorNombre(String nombre) {
        return this.repoCategoria.findByNombre(nombre);
    }

    public List<Categoria> buscarPorNombreContiene(String nombre) {
        return this.repoCategoria.findByNombreContainingIgnoreCase(nombre);
    }

    public List<Categoria> buscarActivas() {
        return this.repoCategoria.categoriasActivas();
    }
}

