/*
 * Decompiled with CFR 0.152.
 */
package web.Regional_Api.service.jpa;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import web.Regional_Api.entity.DetallePedido;
import web.Regional_Api.entity.Pedido;
import web.Regional_Api.repository.DetallePedidoRepository;
import web.Regional_Api.repository.PedidoRepository;
import web.Regional_Api.service.IDetallePedidoService;

@Service
public class DetallePedidoService
implements IDetallePedidoService {
    @Autowired
    private DetallePedidoRepository repoDetallePedido;
    @Autowired
    private PedidoRepository repoPedido;

    public List<DetallePedido> buscarTodos() {
        return this.repoDetallePedido.findAll();
    }

    @Transactional
    public DetallePedido guardar(DetallePedido detallePedido) {
        detallePedido.calcularSubtotal();
        DetallePedido guardado = (DetallePedido)this.repoDetallePedido.save((Object)detallePedido);
        this.actualizarMontoTotalPedido(detallePedido.getPedido().getIdPedido());
        return guardado;
    }

    @Transactional
    public DetallePedido modificar(DetallePedido detallePedido) {
        detallePedido.calcularSubtotal();
        DetallePedido modificado = (DetallePedido)this.repoDetallePedido.save((Object)detallePedido);
        this.actualizarMontoTotalPedido(detallePedido.getPedido().getIdPedido());
        return modificado;
    }

    public Optional<DetallePedido> buscarId(Integer id) {
        return this.repoDetallePedido.findById((Object)id);
    }

    @Transactional
    public void eliminar(Integer id) {
        Optional optional = this.repoDetallePedido.findById((Object)id);
        if (optional.isPresent()) {
            DetallePedido detalle = (DetallePedido)optional.get();
            Integer idPedido = detalle.getPedido().getIdPedido();
            this.repoDetallePedido.deleteById((Object)id);
            this.actualizarMontoTotalPedido(idPedido);
        }
    }

    public List<DetallePedido> buscarPorPedido(Integer idPedido) {
        return this.repoDetallePedido.buscarPorPedido(idPedido);
    }

    public List<DetallePedido> buscarPorPlato(Integer idPlato) {
        return this.repoDetallePedido.buscarPorPlato(idPlato);
    }

    @Transactional
    private void actualizarMontoTotalPedido(Integer idPedido) {
        Optional optionalPedido = this.repoPedido.findById((Object)idPedido);
        if (optionalPedido.isPresent()) {
            Pedido pedido = (Pedido)optionalPedido.get();
            List detalles = this.repoDetallePedido.buscarPorPedido(idPedido);
            BigDecimal total = detalles.stream().map(DetallePedido::getSubtotal).reduce(BigDecimal.ZERO, BigDecimal::add);
            pedido.setMontoTotal(total);
            pedido.setFechaUpdate(LocalDateTime.now());
            this.repoPedido.save((Object)pedido);
        }
    }
}

