/*
 * Decompiled with CFR 0.152.
 */
package web.Regional_Api.service.jpa;

import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeMessage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import web.Regional_Api.service.EmailService;

@Service
public class EmailServiceImpl
implements EmailService {
    @Autowired
    private JavaMailSender mailSender;
    private final String REMITENTE_OFICIAL = "admin@comidas.spring.informaticapp.com";

    @Async
    public void enviarTokenSuperAdmin(String destinatario, String token, String nombreUsuario) {
        try {
            MimeMessage message = this.mailSender.createMimeMessage();
            MimeMessageHelper helper = new MimeMessageHelper(message, true, "UTF-8");
            helper.setFrom("admin@comidas.spring.informaticapp.com");
            helper.setTo(destinatario);
            String asuntoUnico = "\ud83d\udd10 Token SuperAdmin - " + System.currentTimeMillis();
            helper.setSubject(asuntoUnico);
            helper.setText(this.construirEmailHTML(token, nombreUsuario), true);
            this.mailSender.send(message);
            System.out.println("\u2705 Email enviado exitosamente a: " + destinatario);
        }
        catch (MessagingException e) {
            System.err.println("\u274c Error al enviar email: " + e.getMessage());
            e.printStackTrace();
            throw new RuntimeException("Error al enviar el correo electr\u00f3nico: " + e.getMessage(), e);
        }
        catch (Exception e) {
            System.err.println("\u274c Error inesperado al enviar email: " + e.getMessage());
            e.printStackTrace();
            throw new RuntimeException("Error inesperado al enviar el correo electr\u00f3nico: " + e.getMessage(), e);
        }
    }

    private String construirEmailHTML(String token, String nombreUsuario) {
        return String.format("<div style='font-family: Arial, sans-serif; margin: 0; padding: 20px; background-color: #f3f4f6;'>  <div style='max-width: 600px; margin: 0 auto; background-color: white; border-radius: 8px; overflow: hidden; box-shadow: 0 2px 4px rgba(0,0,0,0.1);'>        <div style='background-color: #DC2626; color: white; padding: 30px 20px; text-align: center;'>      <h1 style='margin: 0; font-size: 24px;'>\ud83d\udd10 Token de Acceso</h1>    </div>        <div style='padding: 30px 20px; color: #374151;'>      <p style='font-size: 16px; margin-bottom: 20px;'>Hola <strong>%s</strong>,</p>      <p style='margin-bottom: 20px;'>Has solicitado acceso al Panel SuperAdmin. Aqu\u00ed est\u00e1 tu token:</p>            <div style='background-color: #f8fafc; border: 2px solid #DC2626; padding: 15px; border-radius: 6px; margin: 25px 0;'>        <p style='color: #DC2626; font-weight: bold; margin: 0 0 10px 0; font-size: 13px;'>\ud83d\udd11 Tu Token JWT:</p>        <div style='font-family: monospace; word-break: break-all; color: #1f2937; font-size: 14px; line-height: 1.4;'>          %s        </div>      </div>            <div style='background-color: #fff; border: 1px solid #e5e7eb; padding: 15px; border-radius: 6px;'>        <h3 style='color: #DC2626; margin-top: 0; font-size: 16px;'>\ud83d\udccb Pasos a seguir:</h3>        <ol style='padding-left: 20px; margin-bottom: 0; color: #4b5563;'>          <li style='margin-bottom: 5px;'>Copia el token completo.</li>          <li style='margin-bottom: 5px;'>P\u00e9galo en el login del SuperAdmin.</li>          <li>Haz clic en Ingresar.</li>        </ol>      </div>      <p style='margin-top: 30px; font-size: 12px; color: #9ca3af; text-align: center;'>        Este token expirar\u00e1 pronto por seguridad.<br>Sistema de Gesti\u00f3n Regional      </p>    </div>  </div></div>", nombreUsuario, token);
    }

    public void sendEmail(String destinatario, String asunto, String contenido) {
        try {
            MimeMessage message = this.mailSender.createMimeMessage();
            MimeMessageHelper helper = new MimeMessageHelper(message, true, "UTF-8");
            helper.setFrom("admin@comidas.spring.informaticapp.com");
            helper.setTo(destinatario);
            helper.setSubject(asunto);
            helper.setText(contenido, true);
            this.mailSender.send(message);
            System.out.println("\u2705 Email enviado exitosamente a: " + destinatario);
        }
        catch (MessagingException e) {
            System.err.println("\u274c Error al enviar email: " + e.getMessage());
            e.printStackTrace();
            throw new RuntimeException("Error al enviar el correo electr\u00f3nico: " + e.getMessage(), e);
        }
        catch (Exception e) {
            System.err.println("\u274c Error inesperado al enviar email: " + e.getMessage());
            e.printStackTrace();
            throw new RuntimeException("Error inesperado al enviar el correo electr\u00f3nico: " + e.getMessage(), e);
        }
    }
}

