/*
 * Decompiled with CFR 0.152.
 */
package web.Regional_Api.service.jpa;

import jakarta.persistence.EntityNotFoundException;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import web.Regional_Api.entity.MovimientosCaja;
import web.Regional_Api.repository.MovimientosCajaRepository;
import web.Regional_Api.service.IMovimientosCajaService;
import web.Regional_Api.service.ISesionesCajaService;

@Service
@Transactional
public class MovimientosCajaService
implements IMovimientosCajaService {
    @Autowired
    private MovimientosCajaRepository repoMovimientos;
    @Autowired
    private ISesionesCajaService serviceSesiones;

    public List<MovimientosCaja> buscarTodos() {
        return this.repoMovimientos.findAll();
    }

    public void registrarMovimiento(MovimientosCaja movimiento) {
        this.serviceSesiones.buscarId(movimiento.getIdSesion()).filter(s -> s.getEstado() == 1).orElseThrow(() -> new RuntimeException("No se puede registrar el movimiento: La sesi\u00f3n no existe o est\u00e1 cerrada."));
        movimiento.setFechaMovimiento(LocalDateTime.now());
        this.repoMovimientos.save((Object)movimiento);
    }

    public void modificarMovimiento(MovimientosCaja movimientoActualizado) {
        this.repoMovimientos.findById((Object)movimientoActualizado.getIdMovimientoCaja()).orElseThrow(() -> new EntityNotFoundException("Movimiento de caja no encontrado para modificar."));
        this.repoMovimientos.save((Object)movimientoActualizado);
    }

    public void eliminarMovimiento(Integer idMovimiento) {
        this.repoMovimientos.findById((Object)idMovimiento).orElseThrow(() -> new EntityNotFoundException("Movimiento de caja no encontrado para eliminar."));
        this.repoMovimientos.deleteById((Object)idMovimiento);
    }

    public List<MovimientosCaja> buscarPorSesion(Integer idSesion) {
        return this.repoMovimientos.findByIdSesion(idSesion);
    }

    public BigDecimal calcularTotalMovimientos(Integer idSesion) {
        List movimientos = this.buscarPorSesion(idSesion);
        AtomicReference<BigDecimal> total = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
        movimientos.forEach(m -> total.set(((BigDecimal)total.get()).add(m.getMonto())));
        return total.get();
    }
}

