/*
 * Decompiled with CFR 0.152.
 */
package web.Regional_Api.service.jpa;

import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import web.Regional_Api.entity.Insumos;
import web.Regional_Api.entity.MovimientosInventario;
import web.Regional_Api.repository.InsumosRepository;
import web.Regional_Api.repository.MovimientosInventarioRepository;
import web.Regional_Api.service.IMovimientosInventarioService;

@Service
public class MovimientosInventarioService
implements IMovimientosInventarioService {
    @Autowired
    private MovimientosInventarioRepository repoMovimientos;
    @Autowired
    private InsumosRepository repoInsumos;

    @Transactional(readOnly=true)
    public List<MovimientosInventario> buscarTodos() {
        return this.repoMovimientos.findAll();
    }

    @Transactional(readOnly=true)
    public Optional<MovimientosInventario> buscarId(Integer id) {
        return this.repoMovimientos.findById((Object)id);
    }

    @Transactional
    public MovimientosInventario guardar(MovimientosInventario movimiento) {
        Insumos insumo = (Insumos)this.repoInsumos.findById((Object)movimiento.getInsumo().getId_insumo()).orElseThrow(() -> new RuntimeException("El insumo no existe"));
        BigDecimal cantidad = movimiento.getCantidad();
        MovimientosInventario.TipoMovimiento tipo = movimiento.getTipo_movimiento();
        if (tipo == MovimientosInventario.TipoMovimiento.Salida) {
            insumo.setStock_actual(insumo.getStock_actual().subtract(cantidad));
            if (insumo.getStock_actual().compareTo(BigDecimal.ZERO) < 0) {
                throw new RuntimeException("Stock insuficiente");
            }
        } else {
            insumo.setStock_actual(insumo.getStock_actual().add(cantidad));
        }
        this.repoInsumos.save((Object)insumo);
        return (MovimientosInventario)this.repoMovimientos.save((Object)movimiento);
    }
}

