/*
 * Decompiled with CFR 0.152.
 */
package web.Regional_Api.service.jpa;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import web.Regional_Api.entity.DetallePedido;
import web.Regional_Api.entity.Pedido;
import web.Regional_Api.repository.PedidoRepository;
import web.Regional_Api.service.IPedidoService;

@Service
public class PedidoService
implements IPedidoService {
    @Autowired
    private PedidoRepository repoPedido;

    public List<Pedido> buscarTodos() {
        return this.repoPedido.findAll();
    }

    @Transactional
    public Pedido guardar(Pedido pedido) {
        if (pedido.getFechaHora() == null) {
            pedido.setFechaHora(LocalDateTime.now());
        }
        if (pedido.getFechaUpdate() == null) {
            pedido.setFechaUpdate(LocalDateTime.now());
        }
        if (pedido.getEstadoPedido() == null) {
            pedido.setEstadoPedido("Pendiente");
        }
        if (pedido.getDetalles() != null) {
            pedido.getDetalles().forEach(d -> d.setPedido(pedido));
            BigDecimal total = pedido.getDetalles().stream().map(DetallePedido::getSubtotal).reduce(BigDecimal.ZERO, BigDecimal::add);
            pedido.setMontoTotal(total);
        } else {
            pedido.setMontoTotal(BigDecimal.ZERO);
        }
        return (Pedido)this.repoPedido.save((Object)pedido);
    }

    @Transactional
    public Pedido modificar(Pedido pedido) {
        pedido.setFechaUpdate(LocalDateTime.now());
        if (pedido.getDetalles() != null) {
            pedido.getDetalles().forEach(d -> d.setPedido(pedido));
            BigDecimal total = pedido.getDetalles().stream().map(DetallePedido::getSubtotal).reduce(BigDecimal.ZERO, BigDecimal::add);
            pedido.setMontoTotal(total);
        }
        return (Pedido)this.repoPedido.save((Object)pedido);
    }

    public Optional<Pedido> buscarId(Integer id) {
        return this.repoPedido.findById((Object)id);
    }

    @Transactional
    public void eliminar(Integer id) {
        Optional optional = this.repoPedido.findById((Object)id);
        optional.ifPresent(p -> {
            p.setEstadoPedido("Cancelado");
            this.repoPedido.save(p);
        });
    }

    public List<Pedido> buscarPorSucursal(Integer idSucursal) {
        return this.repoPedido.findByIdSucursal(idSucursal);
    }

    public List<Pedido> buscarPorEstado(String estadoPedido) {
        return this.repoPedido.findByEstadoPedido(estadoPedido);
    }

    public List<Pedido> buscarPorUsuario(Integer idUsuario) {
        return this.repoPedido.findByIdUsuario(idUsuario);
    }

    public List<Pedido> buscarPorMesa(Integer idMesa) {
        return this.repoPedido.findByIdMesa(idMesa);
    }

    public List<Pedido> buscarPorFecha(LocalDateTime fechaInicio, LocalDateTime fechaFin) {
        return this.repoPedido.buscarPorFecha(fechaInicio, fechaFin);
    }

    public List<Pedido> buscarPorSucursalYEstado(Integer idSucursal, String estadoPedido) {
        return this.repoPedido.buscarPorSucursalYEstado(idSucursal, estadoPedido);
    }

    public List<Pedido> buscarPorTipoPedido(String tipoPedido) {
        return this.repoPedido.findByTipoPedido(tipoPedido);
    }

    public List<Pedido> buscarPedidosActivos(Integer idSucursal) {
        return this.repoPedido.buscarPedidosActivosBySucursal(idSucursal);
    }

    public List<Pedido> buscarPorNombreCliente(String nombreCliente) {
        return this.repoPedido.buscarPorNombreCliente(nombreCliente);
    }

    public Optional<Pedido> buscarUltimoPedidoActivoByMesa(Integer idMesa) {
        return this.repoPedido.findUltimoPedidoActivoByMesa(idMesa);
    }

    public List<Pedido> buscarPorPlato(Integer idPlato) {
        return this.repoPedido.buscarPorPlato(idPlato);
    }
}

