/*
 * Decompiled with CFR 0.152.
 */
package web.Regional_Api.service.jpa;

import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import web.Regional_Api.entity.Plato;
import web.Regional_Api.repository.PlatoRepository;
import web.Regional_Api.service.IPlatoService;

@Service
@Transactional(readOnly=true)
public class PlatoService
implements IPlatoService {
    @Autowired
    private PlatoRepository repoPlato;

    public List<Plato> buscarTodos() {
        return this.repoPlato.findAll();
    }

    @Transactional
    public Plato guardar(Plato plato) {
        return (Plato)this.repoPlato.save((Object)plato);
    }

    @Transactional
    public Plato modificar(Plato plato) {
        return (Plato)this.repoPlato.save((Object)plato);
    }

    public Optional<Plato> buscarId(Integer id) {
        return this.repoPlato.findById((Object)id);
    }

    @Transactional
    public void eliminar(Integer id) {
        Optional optional = this.repoPlato.findById((Object)id);
        optional.ifPresent(p -> {
            p.setEstado(Integer.valueOf(0));
            this.repoPlato.save(p);
        });
    }

    public List<Plato> buscarPorCategoria(Integer idCategoria) {
        return this.repoPlato.buscarPorCategoria(idCategoria);
    }

    public List<Plato> buscarDisponiblesPorCategoria(Integer idCategoria) {
        return this.repoPlato.platosDisponiblesPorCategoria(idCategoria);
    }

    public List<Plato> buscarPorNombre(String nombre) {
        return this.repoPlato.buscarPorNombre(nombre);
    }

    public List<Plato> buscar(String search) {
        return this.repoPlato.buscarPorNombre(search);
    }

    public List<Plato> buscarPorDisponibilidad(Integer disponible) {
        return this.repoPlato.findByEstado(disponible);
    }
}

