/*
 * Decompiled with CFR 0.152.
 */
package web.Regional_Api.service.jpa;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import web.Regional_Api.entity.Reporte;
import web.Regional_Api.entity.SuperAdmin;
import web.Regional_Api.repository.ReporteRepository;
import web.Regional_Api.service.IReporteService;

@Service
public class ReporteService
implements IReporteService {
    @Autowired
    private ReporteRepository reporteRepository;

    @Transactional
    public void registrarAccion(SuperAdmin superAdmin, String accion, String detalle, String ip) {
        try {
            Reporte reporte = new Reporte(accion, detalle, ip, superAdmin);
            this.reporteRepository.save((Object)reporte);
        }
        catch (Exception e) {
            System.err.println("Error al guardar reporte: " + e.getMessage());
        }
    }

    public List<Reporte> obtenerTodos() {
        return this.reporteRepository.findAllByOrderByFechaDesc();
    }

    public List<Reporte> obtenerPorSuperAdmin(Integer id) {
        return this.reporteRepository.findBySuperAdmin_IdSuperAdminOrderByFechaDesc(id);
    }
}

