/*
 * Decompiled with CFR 0.152.
 */
package web.Regional_Api.service.jpa;

import jakarta.persistence.EntityNotFoundException;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import web.Regional_Api.entity.SesionesCaja;
import web.Regional_Api.repository.SesionesCajaRepository;
import web.Regional_Api.service.ISesionesCajaService;

@Service
@Transactional
public class SesionesCajaService
implements ISesionesCajaService {
    @Autowired
    private SesionesCajaRepository repoSesiones;

    public Optional<SesionesCaja> buscarId(Integer id) {
        return this.repoSesiones.findById((Object)id);
    }

    public List<SesionesCaja> buscarTodas() {
        return this.repoSesiones.findAll();
    }

    public void abrirCaja(SesionesCaja nuevaSesion) {
        this.repoSesiones.save((Object)nuevaSesion);
    }

    public List<SesionesCaja> buscarTodasPorSucursal(Integer idSucursal) {
        return this.repoSesiones.findByIdSucursal(idSucursal);
    }

    public Optional<SesionesCaja> buscarSesionAbiertaPorSucursal(Integer idSucursal) {
        return this.repoSesiones.findByIdSucursalAndEstado(idSucursal, Integer.valueOf(1));
    }

    public Optional<SesionesCaja> buscarIdYSucursal(Integer idSesion, Integer idSucursal) {
        return this.repoSesiones.findByIdSesionAndIdSucursal(idSesion, idSucursal);
    }

    public void cerrarCaja(SesionesCaja datosCierre) {
        this.repoSesiones.save((Object)datosCierre);
    }

    public void eliminar(Integer idSesion) {
        this.repoSesiones.findById((Object)idSesion).orElseThrow(() -> new EntityNotFoundException("Sesi\u00f3n no encontrada para eliminar."));
        this.repoSesiones.deleteById((Object)idSesion);
    }
}

