/*
 * Decompiled with CFR 0.152.
 */
package web.Regional_Api.service.jpa;

import jakarta.persistence.EntityNotFoundException;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import web.Regional_Api.entity.Sucursales;
import web.Regional_Api.repository.SucursalesRepository;
import web.Regional_Api.service.ISucursalesService;

@Service
public class SucursalesService
implements ISucursalesService {
    @Autowired
    private SucursalesRepository repoSucursales;

    public Optional<Sucursales> buscarId(Integer id) {
        return this.repoSucursales.findById((Object)id);
    }

    public List<Sucursales> buscarTodos() {
        return this.repoSucursales.findAll();
    }

    public List<Sucursales> buscarTodosPorRestaurante(Integer idRestaurante) {
        return this.repoSucursales.findByIdRestaurante(idRestaurante);
    }

    public Sucursales guardar(Sucursales sucursal) {
        return (Sucursales)this.repoSucursales.save((Object)sucursal);
    }

    public void modificar(Sucursales sucursalActualizada) {
        this.repoSucursales.findById((Object)sucursalActualizada.getIdSucursal()).orElseThrow(() -> new EntityNotFoundException("Sucursal no encontrada para modificar."));
        this.repoSucursales.save((Object)sucursalActualizada);
    }

    public Optional<Sucursales> buscarIdYRestaurante(Integer idSucursal, Integer idRestaurante) {
        return this.repoSucursales.findByIdSucursalAndIdRestaurante(idSucursal, idRestaurante);
    }

    public void eliminar(Integer idSucursal) {
        this.repoSucursales.findById((Object)idSucursal).orElseThrow(() -> new EntityNotFoundException("Sucursal no encontrada para eliminar."));
        this.repoSucursales.deleteById((Object)idSucursal);
    }
}

