/*
 * Decompiled with CFR 0.152.
 */
package web.Regional_Api.service.jpa;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;
import web.Regional_Api.entity.SuperAdmin;
import web.Regional_Api.repository.SuperAdminRepository;
import web.Regional_Api.service.ISuperAdminService;

@Service
public class SuperAdminService
implements ISuperAdminService,
UserDetailsService {
    @Autowired
    private SuperAdminRepository superAdminRepository;

    public List<SuperAdmin> getAllSuperAdmins() {
        return this.superAdminRepository.findAll();
    }

    public Optional<SuperAdmin> getSuperAdminById(Integer id) {
        Objects.requireNonNull(id, "El id no puede ser nulo");
        return this.superAdminRepository.findById((Object)id);
    }

    public SuperAdmin createSuperAdmin(SuperAdmin superAdmin) {
        if (this.superAdminRepository.existsByEmail(superAdmin.getEmail())) {
            throw new RuntimeException("El email ya est\u00e1 registrado");
        }
        superAdmin.setPassword(this.hashPassword(superAdmin.getPassword()));
        return (SuperAdmin)this.superAdminRepository.save((Object)superAdmin);
    }

    public Optional<SuperAdmin> updateSuperAdmin(Integer id, SuperAdmin superAdmin) {
        Objects.requireNonNull(id, "El id no puede ser nulo");
        Optional existenteOpt = this.superAdminRepository.findById((Object)id);
        if (existenteOpt.isEmpty()) {
            return Optional.empty();
        }
        SuperAdmin existente = (SuperAdmin)existenteOpt.get();
        if (superAdmin.getNombres() != null) {
            existente.setNombres(superAdmin.getNombres());
        }
        if (superAdmin.getEmail() != null) {
            if (!existente.getEmail().equals(superAdmin.getEmail()) && this.superAdminRepository.existsByEmail(superAdmin.getEmail())) {
                throw new RuntimeException("El email ya est\u00e1 registrado");
            }
            existente.setEmail(superAdmin.getEmail());
        }
        if (superAdmin.getPassword() != null && !superAdmin.getPassword().isEmpty()) {
            existente.setPassword(this.hashPassword(superAdmin.getPassword()));
        }
        if (superAdmin.getRol() != null) {
            existente.setRol(superAdmin.getRol());
        }
        if (superAdmin.getTokenLogin() != null) {
            existente.setTokenLogin(superAdmin.getTokenLogin());
        }
        return Optional.of((SuperAdmin)this.superAdminRepository.save((Object)existente));
    }

    public void deleteSuperAdmin(Integer id) {
        Objects.requireNonNull(id, "El id no puede ser nulo");
        if (!this.superAdminRepository.existsById((Object)id)) {
            throw new RuntimeException("SuperAdmin no encontrado");
        }
        this.superAdminRepository.deleteById((Object)id);
    }

    public Optional<SuperAdmin> getSuperAdminByEmail(String email) {
        return this.superAdminRepository.findByEmail(email);
    }

    public Optional<SuperAdmin> getSuperAdminByToken(String token) {
        return this.superAdminRepository.findByTokenLogin(token);
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        return this.superAdminRepository.findByEmail(username).map(admin -> User.builder().username(admin.getEmail()).password(admin.getPassword()).roles(new String[]{admin.getRol()}).build()).orElseThrow(() -> new UsernameNotFoundException("SuperAdmin no encontrado con email: " + username));
    }

    private String hashPassword(String password) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] hash = digest.digest(password.getBytes(StandardCharsets.UTF_8));
            return Base64.getEncoder().encodeToString(hash);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Error al generar hash de contrase\u00f1a", e);
        }
    }
}

