/*
 * Decompiled with CFR 0.152.
 */
package web.Regional_Api.service.jpa;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import web.Regional_Api.entity.Usuarios;
import web.Regional_Api.repository.UsuarioRepository;
import web.Regional_Api.service.IUsuarioService;

@Service
public class UsuarioService
implements IUsuarioService {
    @Autowired
    private UsuarioRepository usuarioRepository;

    public List<Usuarios> getAllUsuarios() {
        return this.usuarioRepository.findAll();
    }

    public Usuarios registrarUsuario(Usuarios usuario) {
        if (this.usuarioRepository.existsByNombreUsuarioLogin(usuario.getNombreUsuarioLogin())) {
            throw new RuntimeException("El nombre de usuario de login ya est\u00e1 registrado en el sistema");
        }
        return (Usuarios)this.usuarioRepository.save((Object)usuario);
    }

    public Usuarios login(String nombreUsuarioLogin, String contrasena) {
        throw new UnsupportedOperationException("La l\u00f3gica de login ahora est\u00e1 manejada por RegistrosService");
    }

    public Usuarios validarToken(String token) {
        throw new UnsupportedOperationException("La validaci\u00f3n de tokens ahora est\u00e1 manejada por RegistrosService");
    }

    public Optional<Usuarios> getUsuarioById(Integer id) {
        Objects.requireNonNull(id, "El id no puede ser nulo");
        return this.usuarioRepository.findById((Object)id);
    }

    public Optional<Usuarios> getUsuarioByLogin(String nombreUsuarioLogin) {
        return this.usuarioRepository.findByNombreUsuarioLogin(nombreUsuarioLogin);
    }

    public Optional<Usuarios> updateUsuario(Integer id, Usuarios usuario) {
        Objects.requireNonNull(id, "El id no puede ser nulo");
        Optional existenteOpt = this.usuarioRepository.findById((Object)id);
        if (existenteOpt.isEmpty()) {
            return Optional.empty();
        }
        Usuarios existente = (Usuarios)existenteOpt.get();
        if (usuario.getNombreUsuario() != null) {
            existente.setNombreUsuario(usuario.getNombreUsuario());
        }
        if (usuario.getNombreUsuario() != null) {
            existente.setNombreUsuario(usuario.getNombreUsuario());
        }
        if (usuario.getApellidos() != null) {
            existente.setApellidos(usuario.getApellidos());
        }
        if (usuario.getDniUsuario() != null) {
            existente.setDniUsuario(usuario.getDniUsuario());
        }
        if (usuario.getTelefono() != null) {
            existente.setTelefono(usuario.getTelefono());
        }
        if (usuario.getContrasena() != null) {
            existente.setContrasena(usuario.getContrasena());
        }
        if (usuario.getRolId() != null) {
            existente.setRolId(usuario.getRolId());
        }
        if (usuario.getIdSucursal() != null) {
            existente.setIdSucursal(usuario.getIdSucursal());
        }
        if (usuario.getEstado() != null) {
            existente.setEstado(usuario.getEstado());
        }
        if (usuario.getUltimoLogin() != null) {
            existente.setUltimoLogin(usuario.getUltimoLogin());
        }
        return Optional.ofNullable((Usuarios)this.usuarioRepository.save((Object)existente));
    }

    public Usuarios saveUsuarios(Usuarios usuario) {
        return (Usuarios)this.usuarioRepository.save((Object)usuario);
    }

    public void deleteUsuario(Integer id) {
        Objects.requireNonNull(id, "El id no puede ser nulo");
        if (!this.usuarioRepository.existsById((Object)id)) {
            throw new RuntimeException("Usuario no encontrado");
        }
        this.usuarioRepository.deleteById((Object)id);
    }

    public List<Usuarios> getUsuariosBySucursal(Integer idSucursal) {
        Objects.requireNonNull(idSucursal, "El idSucursal no puede ser nulo");
        return this.usuarioRepository.findByIdSucursal(idSucursal);
    }
}

