/*
 * Decompiled with CFR 0.152.
 */
package web.Regional_Api.service.jpa;

import jakarta.persistence.EntityNotFoundException;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import web.Regional_Api.entity.Ventas;
import web.Regional_Api.repository.VentasRepository;
import web.Regional_Api.service.ISesionesCajaService;
import web.Regional_Api.service.IVentasService;

@Service
@Transactional
public class VentasService
implements IVentasService {
    @Autowired
    private VentasRepository repoVentas;
    @Autowired
    private ISesionesCajaService serviceSesiones;

    public List<Ventas> buscarTodas() {
        return this.repoVentas.findAll();
    }

    public Ventas registrarVenta(Ventas venta) {
        this.serviceSesiones.buscarId(venta.getIdSesion()).filter(s -> s.getEstado() == 1).orElseThrow(() -> new RuntimeException("No se puede registrar la venta. La sesi\u00f3n de caja est\u00e1 cerrada o no existe."));
        venta.setFechaVenta(LocalDateTime.now());
        return (Ventas)this.repoVentas.save((Object)venta);
    }

    public List<Ventas> buscarTodasPorSesion(Integer idSesion) {
        return this.repoVentas.findByIdSesion(idSesion);
    }

    public Optional<Ventas> buscarId(Integer idVenta) {
        return this.repoVentas.findById((Object)idVenta);
    }

    public void anularVenta(Integer idVenta) {
        Ventas venta = (Ventas)this.repoVentas.findById((Object)idVenta).orElseThrow(() -> new EntityNotFoundException("Venta no encontrada."));
        this.repoVentas.deleteById((Object)venta.getIdVenta());
    }

    public Ventas modificarVenta(Ventas ventaActualizada) {
        this.repoVentas.findById((Object)ventaActualizada.getIdVenta()).orElseThrow(() -> new EntityNotFoundException("Venta no encontrada para modificar."));
        return (Ventas)this.repoVentas.save((Object)ventaActualizada);
    }
}

